/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.endpoints;

import com.google.common.io.InputSupplier;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.endpoints.AbstractClientService;
import org.eclipse.osee.logger.Log;

@Path(value="/client")
public class ClientEndpoint
extends AbstractClientService {
    public ClientEndpoint(Log logger) {
        super(logger);
    }

    @GET
    @Path(value="{application-guid}/logo")
    @Produces(value={"image/png", "image/jpeg", "image/gif"})
    public Response getApplicationLogo(final @Context UriInfo uriInfo, final @PathParam(value="application-guid") String applicationGuid) {
        return Response.ok((Object)new StreamingOutput(){

            public void write(OutputStream outputStream) throws IOException, WebApplicationException {
                InputSupplier<InputStream> supplier = ClientEndpoint.this.getDataProvider().getClientLogoSupplier(uriInfo, applicationGuid);
                if (supplier != null) {
                    InputStream inputStream = null;
                    try {
                        inputStream = (InputStream)supplier.getInput();
                        Lib.inputStreamToOutputStream((InputStream)inputStream, (OutputStream)outputStream);
                    }
                    finally {
                        Lib.close((Closeable)inputStream);
                    }
                }
            }
        }).build();
    }
}

