/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal.security;

import java.security.Principal;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.MessageContextImpl;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.security.SecurityContext;
import org.eclipse.osee.framework.jdk.core.type.OseePrincipal;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.OAuthUtil;
import org.eclipse.osee.jaxrs.server.security.JaxRsAuthenticator;

@Provider
@PreMatching
public class AnonymousPrincipalRequestFilter
implements ContainerRequestFilter {
    private JaxRsAuthenticator authenticator;

    public void setJaxRsAuthenticator(JaxRsAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void filter(ContainerRequestContext requestContext) {
        OseePrincipal anonymousPrincipal;
        javax.ws.rs.core.SecurityContext sc = requestContext.getSecurityContext();
        Principal principal = sc.getUserPrincipal();
        if (principal == null && (anonymousPrincipal = this.authenticator.getAnonymousPrincipal()) != null) {
            SecurityContext securityContext = OAuthUtil.newSecurityContext(anonymousPrincipal);
            MessageContext mc = this.getMessageContext();
            OAuthUtil.saveSecurityContext(mc, securityContext);
        }
    }

    public MessageContext getMessageContext() {
        return new MessageContextImpl(PhaseInterceptorChain.getCurrentMessage());
    }
}

