/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal.ext;

import com.google.common.io.InputSupplier;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public class RestResourceConcatenator {
    private final Set<String> resources = new HashSet<String>();
    private String header;
    private String footer;
    private Pattern resourcePattern = null;

    public void initialize(String xmlTag) {
        if (this.resourcePattern != null) {
            throw new OseeArgumentException("Already initialized", new Object[0]);
        }
        this.validateTag(xmlTag);
        String regex = String.format("(.*?<%s.*?>)(.+?)(</%s>)", xmlTag, xmlTag);
        this.resourcePattern = Pattern.compile(regex, 32);
    }

    public String toString() {
        return String.format("%s Object: \n  contents {%s}\n", this.getClass().getName(), this.getResources());
    }

    public void addResource(InputSupplier<? extends InputStream> supplier) throws IOException {
        Conditions.checkNotNull(supplier, (String)"InputStreamSupplier");
        InputStream is = null;
        try {
            is = (InputStream)supplier.getInput();
            this.processResource(Lib.inputStreamToString((InputStream)is));
        }
        finally {
            Lib.close((Closeable)is);
        }
    }

    public InputStream getAsInputStream() throws UnsupportedEncodingException {
        if (this.resources.isEmpty() || this.header == null || this.footer == null) {
            throw new OseeCoreException("Rest resource not ready - no data", new Object[0]);
        }
        return Lib.stringToInputStream((String)this.getResources());
    }

    public String getResources() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.header);
        for (String resource : this.resources) {
            sb.append(resource);
        }
        sb.append(this.footer);
        return sb.toString();
    }

    private void processResource(String input) {
        Conditions.checkNotNullOrEmpty((String)input, (String)"bundle resource");
        Matcher match = this.resourcePattern.matcher(input);
        while (match.find()) {
            if (this.resources.isEmpty()) {
                this.header = match.group(1);
                this.footer = match.group(3);
            }
            this.resources.add(match.group(2));
        }
    }

    private void validateTag(String xmlTag) {
        Conditions.checkNotNullOrEmpty((String)xmlTag, (String)"xmlTag");
        boolean valid = false;
        if (xmlTag.equals("resourceDoc")) {
            valid = true;
        } else if (xmlTag.equals("applicationDocs")) {
            valid = true;
        } else if (xmlTag.equals("grammars")) {
            valid = true;
        }
        if (!valid) {
            throw new OseeArgumentException("Invalid resource document tag", new Object[0]);
        }
    }
}

