/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal.exceptions;

import java.util.List;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.eclipse.osee.jaxrs.ErrorResponse;
import org.eclipse.osee.jaxrs.OseeWebApplicationException;
import org.eclipse.osee.jaxrs.server.internal.JaxRsUtils;
import org.eclipse.osee.logger.Log;

@Provider
public abstract class AbstractExceptionMapper<T extends Throwable>
implements ExceptionMapper<T> {
    private final Log logger;
    @Context
    private ResourceInfo resourceInfo;
    @Context
    private Providers providers;
    @Context
    private HttpHeaders headers;
    @Context
    private UriInfo uriInfo;

    public AbstractExceptionMapper(Log logger) {
        this.logger = logger;
    }

    public Log getLogger() {
        return this.logger;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public final Response toResponse(T ex) {
        OseeWebApplicationException exception = this.asWebAppException(ex);
        return this.writeResponse(exception);
    }

    protected abstract OseeWebApplicationException asWebAppException(T var1);

    protected Response writeResponse(OseeWebApplicationException exception) {
        ErrorResponse errorResponse = exception.getErrorResponse();
        Response toReturn = exception.getResponse();
        List acceptableMediaTypes = this.headers.getAcceptableMediaTypes();
        if (JaxRsUtils.isHtmlSupported(acceptableMediaTypes)) {
            toReturn = Response.fromResponse((Response)toReturn).entity((Object)errorResponse).type(MediaType.TEXT_HTML_TYPE).build();
        }
        return toReturn;
    }
}

