/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.osee.jaxrs.server.internal.applications.JaxRsApplicationRegistry;
import org.osgi.framework.ServiceReference;

public abstract class JaxRsDynamicServiceManager<T> {
    private final List<ServiceReference<T>> pendingReg = new ArrayList<ServiceReference<T>>();
    private final AtomicReference<JaxRsApplicationRegistry> registryRef = new AtomicReference();

    public void setJaxRsApplicationRegistry(JaxRsApplicationRegistry registry) {
        this.registryRef.set(registry);
    }

    public void unsetJaxRsApplicationRegistry(JaxRsApplicationRegistry registry) {
        this.registryRef.set(null);
    }

    protected JaxRsApplicationRegistry getRegistry() {
        return this.registryRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Map<String, Object> props) {
        this.update(props);
        JaxRsApplicationRegistry registry = this.getRegistry();
        List<ServiceReference<T>> list = this.pendingReg;
        synchronized (list) {
            Iterator<ServiceReference<T>> iterator = this.pendingReg.iterator();
            while (iterator.hasNext()) {
                ServiceReference<T> reference = iterator.next();
                this.register(registry, reference);
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(Map<String, Object> props) {
        JaxRsApplicationRegistry registry = this.getRegistry();
        if (registry != null) {
            List<ServiceReference<T>> list = this.pendingReg;
            synchronized (list) {
                Iterator<ServiceReference<T>> iterator = this.pendingReg.iterator();
                while (iterator.hasNext()) {
                    ServiceReference<T> reference = iterator.next();
                    this.deregister(registry, reference);
                    iterator.remove();
                }
            }
        }
    }

    public void update(Map<String, Object> props) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addService(ServiceReference<T> reference) {
        JaxRsApplicationRegistry registry = this.getRegistry();
        if (registry != null) {
            this.register(registry, reference);
        } else {
            List<ServiceReference<T>> list = this.pendingReg;
            synchronized (list) {
                this.pendingReg.add(reference);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeService(ServiceReference<T> reference) {
        JaxRsApplicationRegistry registry = this.getRegistry();
        if (registry != null) {
            this.deregister(registry, reference);
        } else {
            List<ServiceReference<T>> list = this.pendingReg;
            synchronized (list) {
                this.pendingReg.remove(reference);
            }
        }
    }

    public abstract void register(JaxRsApplicationRegistry var1, ServiceReference<T> var2);

    public abstract void deregister(JaxRsApplicationRegistry var1, ServiceReference<T> var2);
}

