/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.utility;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import javax.ws.rs.core.HttpHeaders;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RestUtil {
    public static String jsonToPretty(String json) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonParser jp = new JsonParser();
        JsonElement je = jp.parse(json);
        String pretty = gson.toJson(je);
        return pretty;
    }

    public static JSONObject toJson(String json) throws Exception {
        return new JSONObject(json);
    }

    public static String jsonToPretty(JSONObject json, boolean pretty) {
        return pretty ? RestUtil.jsonToPretty(json.toString()) : json.toString();
    }

    public static String jsonToPretty(JSONArray json, boolean pretty) {
        return pretty ? RestUtil.jsonToPretty(json.toString()) : json.toString();
    }

    public static JSONArray getDefaultJSonArray(ResultSet<ArtifactReadable> artifacts) throws JSONException {
        return RestUtil.getDefaultJSonArrayIterator(artifacts);
    }

    public static JSONArray getDefaultJSonArrayIterator(Iterable<ArtifactReadable> artifacts) throws JSONException {
        JSONArray jsonArray = new JSONArray();
        for (ArtifactReadable art : artifacts) {
            JSONObject jObj = new JSONObject();
            jObj.put("name", (Object)art.getName());
            jObj.put("uuid", (Object)art.getUuid());
            jsonArray.put((Object)jObj);
        }
        return jsonArray;
    }

    public static JSONObject getDefaultJSon(ArtifactReadable art) throws JSONException {
        JSONObject jObj = new JSONObject();
        jObj.put("name", (Object)art.getName());
        jObj.put("uuid", (Object)art.getUuid());
        return jObj;
    }

    public static JSONObject getJsonObject(OrcsApi orcsApi, ArtifactReadable artifact) throws Exception, JSONException {
        JSONObject jsonObj = RestUtil.getDefaultJSon(artifact);
        RestUtil.addAttributes(orcsApi, jsonObj, artifact);
        return jsonObj;
    }

    public static JSONArray getJsonArray(OrcsApi orcsApi, ResultSet<ArtifactReadable> artifacts) throws Exception, JSONException {
        JSONArray jsonArray = new JSONArray();
        for (ArtifactReadable artifact : artifacts) {
            JSONObject jsonObj = RestUtil.getJsonObject(orcsApi, artifact);
            jsonArray.put((Object)jsonObj);
        }
        return jsonArray;
    }

    public static JSONObject addAttributes(OrcsApi orcsApi, JSONObject jsonObj, ArtifactReadable art) throws Exception {
        RestUtil.addAttributesWithValues(orcsApi, jsonObj, art);
        return jsonObj;
    }

    private static JSONObject addAttributesWithValues(OrcsApi orcsApi, JSONObject jsonObj, ArtifactReadable artifact) throws Exception {
        RestUtil.addAttribute(orcsApi, jsonObj, artifact);
        return jsonObj;
    }

    private static void addAttribute(OrcsApi orcsApi, JSONObject jsonObj, ArtifactReadable art) throws Exception {
        for (AttributeTypeToken attrType : orcsApi.getOrcsTypes().getAttributeTypes().getAll()) {
            ResultSet<? extends AttributeReadable<Object>> attributeVals;
            if (!art.isAttributeTypeValid((AttributeTypeId)attrType) || (attributeVals = art.getAttributes()).isEmpty()) continue;
            if (art.isAttributeTypeValid((AttributeTypeId)attrType) && orcsApi.getOrcsTypes().getAttributeTypes().getMaxOccurrences((AttributeTypeId)attrType) > 1) {
                ArrayList<String> attributeValues = new ArrayList<String>();
                for (AttributeReadable attrRead : attributeVals) {
                    String valueStr = String.valueOf(attrRead.getValue());
                    attributeValues.add(valueStr);
                }
                if (attributeValues.isEmpty()) continue;
                jsonObj.put(attrType.getName(), attributeValues);
                continue;
            }
            if (attributeVals.size() != 1) continue;
            String valueStr = String.valueOf(((AttributeReadable)attributeVals.iterator().next()).getValue());
            jsonObj.put(attrType.getName(), (Object)valueStr);
        }
    }

    public static String getClientId(HttpHeaders httpHeaders) {
        String clientId = httpHeaders.getHeaderString("osee.client.id");
        if (clientId == null) {
            clientId = "";
        }
        return clientId;
    }

    public static String getAccountId(HttpHeaders httpHeaders) {
        String clientId = httpHeaders.getHeaderString("osee.account.id");
        if (clientId == null) {
            clientId = "";
        }
        return clientId;
    }

    public static String getServerId(HttpHeaders httpHeaders) {
        String clientId = httpHeaders.getHeaderString("osee.server.id");
        if (clientId == null) {
            clientId = "";
        }
        return clientId;
    }

    public static ArtifactReadable getUserByAccountId(String accountId, OrcsApi orcsApi) {
        ArtifactReadable userArt = null;
        if (Strings.isNumeric((String)accountId)) {
            userArt = RestUtil.getUserByAccountId(Long.valueOf(accountId), orcsApi);
        }
        return userArt;
    }

    public static ArtifactReadable getUserByAccountId(Long accountId, OrcsApi orcsApi) {
        ArtifactReadable user = (ArtifactReadable)((QueryBuilder)orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andUuid(accountId.intValue())).getResults().getAtMostOneOrNull();
        return user;
    }
}

