/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.utility;

import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.type.Named;
import org.eclipse.osee.orcs.utility.SortOrder;

public class NameComparator
implements Comparator<Named> {
    private static final int NUMBER_STRING_LIMIT = 19;
    private static final Pattern numberPattern = Pattern.compile("[+-]?\\d+");
    private final Matcher numberMatcher = numberPattern.matcher("");
    private final SortOrder orderType;

    public NameComparator(SortOrder orderType) {
        this.orderType = orderType;
    }

    private String getName(Named name) {
        String nameString = name != null ? name.getName() : "";
        return nameString != null ? nameString : "";
    }

    @Override
    public int compare(Named o1, Named o2) {
        String name2;
        String name1 = this.getName(o1);
        if (this.areNumbers(name1, name2 = this.getName(o2)) && name1.length() < 19 && name2.length() < 19) {
            if (this.orderType.isAscending()) {
                return Long.valueOf(name1).compareTo(Long.valueOf(name2));
            }
            return Long.valueOf(name2).compareTo(Long.valueOf(name1));
        }
        if (this.orderType.isAscending()) {
            return name1.compareTo(name2);
        }
        return name2.compareTo(name1);
    }

    private boolean areNumbers(String o1, String o2) {
        boolean result = false;
        if (o1 != null && o2 != null) {
            this.numberMatcher.reset(o1);
            if (this.numberMatcher.matches()) {
                this.numberMatcher.reset(o2);
                if (this.numberMatcher.matches()) {
                    result = true;
                }
            }
        }
        return result;
    }
}

