/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.server.internal.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.jdbc.JdbcClient;

public class OseeInfo {
    private static final String GET_VALUE_SQL = "Select OSEE_VALUE FROM osee_info where OSEE_KEY = ?";
    public static final String DB_ID_KEY = "osee.db.guid";
    private static Map<String, String> cache = new HashMap<String, String>();

    public static String getValue(JdbcClient jdbcClient, String key) {
        String toReturn = (String)jdbcClient.fetch((Object)"", GET_VALUE_SQL, new Object[]{key});
        cache.put(key, toReturn);
        return toReturn;
    }

    public static String getDatabaseGuid(JdbcClient jdbcClient) {
        return OseeInfo.getValue(jdbcClient, DB_ID_KEY);
    }

    public static String getCachedValue(JdbcClient jdbcClient, String key) throws OseeCoreException {
        String cacheValue = cache.get(key);
        if (cacheValue == null) {
            cacheValue = OseeInfo.getValue(jdbcClient, key);
            cache.put(key, cacheValue);
        }
        return cacheValue;
    }
}

