/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.server.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import org.eclipse.osee.framework.core.data.OseeCodeVersion;
import org.eclipse.osee.framework.core.data.OseeServerInfo;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.core.server.IApplicationServerManager;
import org.eclipse.osee.framework.core.server.OseeHttpServlet;
import org.eclipse.osee.framework.core.server.OseeServerProperties;
import org.eclipse.osee.framework.core.server.internal.ApplicationServerDataStore;
import org.eclipse.osee.framework.core.server.internal.InternalOseeHttpServlet;
import org.eclipse.osee.framework.core.server.internal.OseeServerThread;
import org.eclipse.osee.framework.core.server.internal.OseeServerThreadFactory;
import org.eclipse.osee.framework.core.server.internal.ProcessingStateEnum;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.ChecksumUtil;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.time.GlobalTime;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.logger.Log;

public class ApplicationServerManager
implements IApplicationServerManager {
    private final Map<String, OseeServerThreadFactory> threadFactories;
    private final Map<String, InternalOseeHttpServlet> oseeHttpServlets = new ConcurrentHashMap<String, InternalOseeHttpServlet>();
    private Log logger;
    private JdbcService jdbcService;
    private ApplicationServerDataStore dataStore;
    private OseeServerInfo serverInfo;
    private Timer timer;

    public ApplicationServerManager() {
        this.threadFactories = new ConcurrentHashMap<String, OseeServerThreadFactory>();
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public Log getLogger() {
        return this.logger;
    }

    public void setJdbcService(JdbcService dbService) {
        this.jdbcService = dbService;
    }

    public void start() throws Exception {
        this.dataStore = new ApplicationServerDataStore(this.jdbcService.getClient());
        this.serverInfo = ApplicationServerManager.createOseeServerInfo(this.getLogger(), this.dataStore, OseeCodeVersion.getVersion());
        System.setProperty("OseeApplicationServer", this.serverInfo.getUri().toString());
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (this.isDbInitialized()) {
                    try {
                        try {
                            ApplicationServerManager.this.executeLookupRegistration();
                        }
                        catch (Exception ex) {
                            ApplicationServerManager.this.getLogger().error((Throwable)ex, "Error during lookup registration", new Object[0]);
                            ApplicationServerManager.this.timer.cancel();
                        }
                    }
                    finally {
                        ApplicationServerManager.this.timer.cancel();
                    }
                }
            }

            private boolean isDbInitialized() {
                boolean result = false;
                try {
                    String id = ApplicationServerManager.this.dataStore.getDatabaseGuid();
                    if (Strings.isValid((String)id)) {
                        result = true;
                    }
                }
                catch (Exception exception) {}
                return result;
            }
        }, 5000L);
    }

    public void stop() {
        this.shutdown();
    }

    private static OseeServerInfo createOseeServerInfo(Log logger, ApplicationServerDataStore dataStore, String ... defaultVersions) {
        String serverAddress = "127.0.0.1";
        try {
            serverAddress = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {}
        int port = OseeServerProperties.getOseeApplicationServerPort();
        String scheme = OseeServerProperties.getOseeApplicationServerScheme();
        URI uri = null;
        try {
            uri = new URI(scheme, null, serverAddress, port, null, null, null);
        }
        catch (URISyntaxException ex) {
            logger.error((Throwable)ex, "Error generating application server uri", new Object[0]);
        }
        String checkSum = "-1";
        try {
            String address = String.format("%s:%s", serverAddress, port);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(address.getBytes("UTF-8"));
            checkSum = ChecksumUtil.createChecksumAsString((InputStream)inputStream, (String)"MD5");
        }
        catch (Exception ex) {
            logger.error((Throwable)ex, "Error generating application server id", new Object[0]);
        }
        return new OseeServerInfo(checkSum, uri == null ? null : uri.toString(), defaultVersions, GlobalTime.GreenwichMeanTimestamp(), false);
    }

    @Override
    public boolean executeLookupRegistration() {
        OseeServerInfo info = this.getApplicationServerInfo();
        this.deregisterWithDb(info);
        boolean isRegistered = this.registerWithDb(info);
        if (isRegistered) {
            this.getLogger().info("Application Server: [%s] registered.", new Object[]{info.getServerId()});
        }
        return isRegistered;
    }

    @Override
    public void register(String context, OseeHttpServlet servlet) {
        OseeHttpServlet internalServlet = servlet;
        this.oseeHttpServlets.put(context, internalServlet);
    }

    @Override
    public void unregister(String key) {
        this.oseeHttpServlets.remove(key);
        this.threadFactories.remove(key);
    }

    @Override
    public Collection<String> getRegisteredServlets() {
        return this.oseeHttpServlets.keySet();
    }

    private OseeServerInfo getApplicationServerInfo() {
        return this.serverInfo;
    }

    @Override
    public ThreadFactory createNewThreadFactory(String name, int priority) {
        OseeServerThreadFactory factory = new OseeServerThreadFactory(name, priority);
        this.threadFactories.put(name, factory);
        return factory;
    }

    private List<OseeServerThread> getThreadsFromFactory(String key) {
        OseeServerThreadFactory factory = this.threadFactories.get(key);
        return factory.getThreads();
    }

    @Override
    public boolean isSystemIdle() {
        return !Operations.areOperationsScheduled();
    }

    @Override
    public void shutdown() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        OseeServerInfo info = this.getApplicationServerInfo();
        this.deregisterWithDb(info);
    }

    @Override
    public List<String> getCurrentProcesses() {
        ArrayList<String> processList = new ArrayList<String>();
        for (String key : this.threadFactories.keySet()) {
            for (OseeServerThread thread : this.getThreadsFromFactory(key)) {
                Thread.State state = thread.getState();
                if (state.equals((Object)Thread.State.TERMINATED)) continue;
                processList.add(thread.getName());
            }
        }
        for (String contexts : this.oseeHttpServlets.keySet()) {
            InternalOseeHttpServlet servlets = this.oseeHttpServlets.get(contexts);
            if (!servlets.getState().equals((Object)ProcessingStateEnum.BUSY)) continue;
            processList.add(servlets.getCurrentRequest());
        }
        return processList;
    }

    @Override
    public int getNumberOfActiveThreads() {
        int totalProcesses = 0;
        for (String contexts : this.oseeHttpServlets.keySet()) {
            InternalOseeHttpServlet servlet = this.oseeHttpServlets.get(contexts);
            if (!servlet.getState().isBusy()) continue;
            ++totalProcesses;
        }
        for (String key : this.threadFactories.keySet()) {
            for (OseeServerThread thread : this.getThreadsFromFactory(key)) {
                Thread.State state = thread.getState();
                if (Thread.State.TERMINATED == state) continue;
                ++totalProcesses;
            }
        }
        return totalProcesses;
    }

    @Override
    public String getId() {
        return this.getApplicationServerInfo().getServerId();
    }

    @Override
    public URI getServerUri() {
        return this.getApplicationServerInfo().getUri();
    }

    @Override
    public Date getDateStarted() {
        return this.getApplicationServerInfo().getDateStarted();
    }

    @Override
    public String[] getVersions() {
        return this.getApplicationServerInfo().getVersion();
    }

    private boolean deregisterWithDb(OseeServerInfo info) {
        boolean status = false;
        try {
            this.dataStore.delete(info);
            status = true;
        }
        catch (OseeCoreException oseeCoreException) {
            this.getLogger().info("Server lookup table is not initialized", new Object[0]);
        }
        return status;
    }

    private boolean registerWithDb(OseeServerInfo info) {
        boolean status = false;
        try {
            this.dataStore.create(info);
            status = true;
        }
        catch (OseeCoreException oseeCoreException) {
            this.getLogger().info("Server lookup table is not initialized", new Object[0]);
        }
        return status;
    }
}

