/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.server.internal;

import java.net.URI;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.eclipse.osee.framework.core.data.OseeServerInfo;
import org.eclipse.osee.framework.core.server.internal.util.OseeInfo;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcTransaction;

public class ApplicationServerDataStore {
    private final JdbcClient jdbcClient;

    public ApplicationServerDataStore(JdbcClient jdbcClient) {
        this.jdbcClient = jdbcClient;
    }

    public void create(OseeServerInfo info) throws OseeCoreException {
        this.executeTx(TxType.CREATE, info);
    }

    public void update(OseeServerInfo info) throws OseeCoreException {
        this.executeTx(TxType.UPDATE, info);
    }

    public void delete(OseeServerInfo info) throws OseeCoreException {
        this.executeTx(TxType.DELETE, info);
    }

    private void executeTx(TxType op, OseeServerInfo info) throws OseeCoreException {
        this.jdbcClient.runTransaction((JdbcTransaction)new ServerLookupTx(this.jdbcClient, op, info));
    }

    public String getDatabaseGuid() {
        return OseeInfo.getDatabaseGuid(this.jdbcClient);
    }

    private static final class ServerLookupTx
    extends JdbcTransaction {
        private static final String INSERT_LOOKUP_TABLE = "INSERT INTO osee_server_lookup (server_id, version_id, server_uri, start_time, accepts_requests) VALUES (?,?,?,?,?)";
        private static final String DELETE_FROM_LOOKUP_TABLE_BY_ID = "DELETE FROM osee_server_lookup WHERE server_id = ?";
        private final TxType txType;
        private final OseeServerInfo data;
        private final JdbcClient jdbcClient;

        public ServerLookupTx(JdbcClient jdbcClient, TxType txType, OseeServerInfo data) {
            this.jdbcClient = jdbcClient;
            this.txType = txType;
            this.data = data;
        }

        public void handleTxWork(JdbcConnection connection) throws OseeCoreException {
            switch (this.txType) {
                case CREATE: {
                    this.create(connection);
                    break;
                }
                case UPDATE: {
                    this.update(connection);
                    break;
                }
                case DELETE: {
                    this.delete(connection);
                    break;
                }
            }
        }

        private void create(JdbcConnection connection) throws OseeCoreException {
            ArrayList<Object[]> insertData = new ArrayList<Object[]>();
            String serverId = this.data.getServerId();
            URI serverUri = this.data.getUri();
            String uri = serverUri.toString();
            Timestamp dateStarted = this.data.getDateStarted();
            int acceptingRequests = this.data.isAcceptingRequests() ? 1 : 0;
            String[] stringArray = this.data.getVersion();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String version = stringArray[n2];
                insertData.add(new Object[]{serverId, version, uri, dateStarted, acceptingRequests});
                ++n2;
            }
            if (!insertData.isEmpty()) {
                this.jdbcClient.runBatchUpdate(connection, INSERT_LOOKUP_TABLE, insertData);
            }
        }

        private void update(JdbcConnection connection) throws OseeCoreException {
            this.delete(connection);
            this.create(connection);
        }

        private void delete(JdbcConnection connection) throws OseeCoreException {
            ArrayList<Object[]> deleteData = new ArrayList<Object[]>();
            deleteData.add(new Object[]{this.data.getServerId()});
            if (!deleteData.isEmpty()) {
                this.jdbcClient.runBatchUpdate(connection, DELETE_FROM_LOOKUP_TABLE_BY_ID, deleteData);
            }
        }
    }

    private static enum TxType {
        CREATE,
        UPDATE,
        DELETE;

    }
}

