/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.server;

import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.core.server.IAuthenticationProvider;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.search.QueryFactory;

public abstract class AbstractAuthenticationProvider
implements IAuthenticationProvider {
    private Log logger;
    private OrcsApi orcsApi;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    protected Log getLogger() {
        return this.logger;
    }

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    protected OrcsApi getOrcsApi() {
        return this.orcsApi;
    }

    protected UserToken getUserTokenFromOseeDb(String userId) {
        UserToken toReturn = null;
        try {
            QueryFactory queryFactory = this.orcsApi.getQueryFactory();
            QueryBuilder query = (QueryBuilder)((QueryBuilder)queryFactory.fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeId[]{CoreArtifactTypes.User})).and((AttributeTypeId)CoreAttributeTypes.UserId, userId, new QueryOption[0]);
            ArtifactReadable artifact = (ArtifactReadable)query.getResults().getOneOrNull();
            if (artifact != null) {
                toReturn = UserToken.create((long)artifact.getUuid(), (String)((String)artifact.getGuid()), (String)artifact.getName(), (String)artifact.getSoleAttributeAsString((AttributeTypeId)CoreAttributeTypes.Email, ""), (String)userId, (boolean)true, (boolean)false, (boolean)false);
            } else {
                this.getLogger().info("Unable to find userId:[%s] on [%s]", new Object[]{userId, CoreBranches.COMMON});
            }
        }
        catch (OseeCoreException ex) {
            this.getLogger().error((Throwable)ex, "Unable to find userId [%s] in OSEE database.", new Object[]{userId});
        }
        return toReturn;
    }

    protected UserToken createUserToken(boolean isCreationRequired, String userName, String userId, String userEmail, boolean isActive) {
        return UserToken.create((long)Lib.generateArtifactIdAsInt(), (String)GUID.create(), (String)userName, (String)userEmail, (String)userId, (boolean)isActive, (boolean)false, (boolean)isCreationRequired);
    }
}

