/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.resource.management.util;

import java.net.URI;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.resource.management.IResourceLocator;

public class ResourceLocator
implements IResourceLocator {
    private final URI uri;

    public ResourceLocator(URI uri) throws OseeCoreException {
        if (uri == null) {
            throw new OseeArgumentException("URI was null.", new Object[0]);
        }
        this.uri = uri;
    }

    @Override
    public URI getLocation() {
        return this.uri;
    }

    @Override
    public String getProtocol() {
        return this.uri.getScheme();
    }

    public String toString() {
        return this.uri.toString();
    }

    @Override
    public String getRawPath() {
        String toReturn = this.uri.getSchemeSpecificPart();
        if (toReturn.startsWith("//")) {
            toReturn = toReturn.substring(2, toReturn.length());
        }
        return toReturn;
    }
}

