/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.resource.management.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.resource.management.IResource;

public class Resource
implements IResource {
    private final URI uri;
    private final boolean isCompressed;

    public Resource(URI uri, boolean isCompressed) {
        this.uri = uri;
        this.isCompressed = isCompressed;
    }

    @Override
    public InputStream getContent() throws OseeCoreException {
        try {
            return new BufferedInputStream(this.uri.toURL().openStream());
        }
        catch (IOException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    @Override
    public URI getLocation() {
        return this.uri;
    }

    @Override
    public String getName() {
        String value = this.uri.toASCIIString();
        return value.substring(value.lastIndexOf("/") + 1, value.length());
    }

    @Override
    public boolean isCompressed() {
        return this.isCompressed;
    }
}

