/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.resource.management.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.osee.framework.core.exception.OseeNotFoundException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.framework.resource.management.IResource;
import org.eclipse.osee.framework.resource.management.IResourceLocator;
import org.eclipse.osee.framework.resource.management.IResourceLocatorProvider;
import org.eclipse.osee.framework.resource.management.IResourceManager;
import org.eclipse.osee.framework.resource.management.IResourceProvider;

public class ResourceManager
implements IResourceManager {
    private final Collection<IResourceProvider> resourceProviders = new CopyOnWriteArraySet<IResourceProvider>();
    private final Collection<IResourceLocatorProvider> resourceLocatorProviders = new CopyOnWriteArraySet<IResourceLocatorProvider>();

    private IResourceProvider getProvider(IResourceLocator locator) throws OseeCoreException {
        for (IResourceProvider provider : this.resourceProviders) {
            if (!provider.isValid(locator)) continue;
            return provider;
        }
        throw new OseeNotFoundException("No resource provider found for Locator: [%s].  Searched providers: [%s]", new Object[]{locator, Arrays.deepToString(this.resourceProviders.toArray())});
    }

    public boolean addResourceProvider(IResourceProvider resourceProvider) {
        return this.resourceProviders.add(resourceProvider);
    }

    public boolean removeResourceProvider(IResourceProvider resourceProvider) {
        return this.resourceProviders.remove(resourceProvider);
    }

    @Override
    public IResource acquire(IResourceLocator locator, PropertyStore options) throws OseeCoreException {
        IResourceProvider provider = this.getProvider(locator);
        IResource toReturn = provider.acquire(locator, options);
        return toReturn;
    }

    @Override
    public IResourceLocator save(IResourceLocator locator, IResource resource, PropertyStore options) throws OseeCoreException {
        IResourceProvider provider = this.getProvider(locator);
        IResourceLocator actualLocator = provider.save(locator, resource, options);
        return actualLocator;
    }

    @Override
    public int delete(IResourceLocator locator) throws OseeCoreException {
        int toReturn = 2;
        IResourceProvider provider = this.getProvider(locator);
        toReturn = provider.delete(locator);
        return toReturn;
    }

    @Override
    public boolean exists(IResourceLocator locator) throws OseeCoreException {
        IResourceProvider provider = this.getProvider(locator);
        return provider.exists(locator);
    }

    @Override
    public Collection<String> getProtocols() {
        HashSet<String> protocols = new HashSet<String>();
        for (IResourceLocatorProvider provider : this.resourceLocatorProviders) {
            protocols.add(provider.getSupportedProtocol());
        }
        return protocols;
    }

    public boolean addResourceLocatorProvider(IResourceLocatorProvider resourceLocatorProvider) {
        return this.resourceLocatorProviders.add(resourceLocatorProvider);
    }

    public boolean removeResourceLocatorProvider(IResourceLocatorProvider resourceLocatorProvider) {
        return this.resourceLocatorProviders.remove(resourceLocatorProvider);
    }

    @Override
    public IResourceLocator generateResourceLocator(String protocol, String seed, String name) throws OseeCoreException {
        IResourceLocatorProvider resourceLocatorProvider = this.getProvider(protocol);
        return resourceLocatorProvider.generateResourceLocator(seed, name);
    }

    @Override
    public IResourceLocator getResourceLocator(String path) throws OseeCoreException {
        IResourceLocatorProvider resourceLocatorProvider = this.getProvider(path);
        return resourceLocatorProvider.getResourceLocator(path);
    }

    private IResourceLocatorProvider getProvider(String protocol) throws OseeCoreException {
        for (IResourceLocatorProvider provider : this.resourceLocatorProviders) {
            if (!provider.isValid(protocol)) continue;
            return provider;
        }
        throw new OseeNotFoundException("No locator proivder found for [%s].  Searched providers: [%s]", new Object[]{protocol, Arrays.deepToString(this.resourceLocatorProviders.toArray())});
    }
}

