/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.executor.admin.internal;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableScheduledFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.eclipse.osee.executor.admin.ExecutionCallback;
import org.eclipse.osee.executor.admin.ExecutorAdmin;
import org.eclipse.osee.executor.admin.internal.ExecutorCache;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.logger.Log;

public class ExecutorAdminImpl
implements ExecutorAdmin {
    public static final String DEFAULT_EXECUTOR = "default.executor";
    private ExecutorCache cache;
    private Log logger;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    private Log getLogger() {
        return this.logger;
    }

    public void start(Map<String, ?> props) {
        this.logger.trace("Starting [%s]...", new Object[]{this.getClass().getSimpleName()});
        this.cache = new ExecutorCache();
    }

    public void stop(Map<String, ?> props) {
        this.logger.trace("Stopping [%s]...", new Object[]{this.getClass().getSimpleName()});
        for (Map.Entry<String, ListeningExecutorService> entry : this.cache.getExecutors().entrySet()) {
            this.shutdown(entry.getKey(), (ExecutorService)entry.getValue());
        }
        this.cache = null;
    }

    public ListeningExecutorService getDefaultExecutor() {
        return this.getExecutor(DEFAULT_EXECUTOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListeningExecutorService getExecutor(String id) {
        ListeningExecutorService service = null;
        ExecutorCache executorCache = this.cache;
        synchronized (executorCache) {
            service = this.cache.getById(id);
            if (service == null) {
                service = this.createExecutor(id, -1);
            }
        }
        if (service == null) {
            throw new OseeStateException("Error creating executor [%s].", new Object[]{id});
        }
        if (service.isShutdown() || service.isTerminated()) {
            throw new OseeStateException("Error executor [%s] was previously shutdown.", new Object[]{id});
        }
        return service;
    }

    @Override
    public <T> Future<T> schedule(Callable<T> callable) {
        return this.schedule(callable, null);
    }

    @Override
    public <T> Future<T> schedule(String id, Callable<T> callable) {
        return this.schedule(id, callable, null);
    }

    @Override
    public <T> Future<T> schedule(Callable<T> callable, ExecutionCallback<T> callback) {
        return this.schedule(DEFAULT_EXECUTOR, callable, callback);
    }

    @Override
    public <T> Future<T> schedule(String id, Callable<T> callable, ExecutionCallback<T> callback) {
        ListenableFuture listenableFuture = this.getExecutor(id).submit(callable);
        if (callback != null) {
            FutureCallback<T> futureCallback = this.asFutureCallback(callback);
            Futures.addCallback((ListenableFuture)listenableFuture, futureCallback);
        }
        return listenableFuture;
    }

    private <T> FutureCallback<T> asFutureCallback(final ExecutionCallback<T> callback) {
        return new FutureCallback<T>(){

            public void onFailure(Throwable arg0) {
                if (arg0 instanceof CancellationException) {
                    callback.onCancelled();
                } else {
                    callback.onFailure(arg0);
                }
            }

            public void onSuccess(T arg0) {
                callback.onSuccess(arg0);
            }
        };
    }

    private ListeningExecutorService createExecutor(String id, int poolSize) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(String.valueOf(id) + "- [%s]").setPriority(5).build();
        ExecutorService executor = null;
        executor = poolSize > 0 ? Executors.newFixedThreadPool(poolSize, threadFactory) : Executors.newCachedThreadPool(threadFactory);
        ListeningExecutorService listeningExecutor = MoreExecutors.listeningDecorator((ExecutorService)executor);
        this.cache.put(id, listeningExecutor);
        return listeningExecutor;
    }

    private void shutdown(String id, ExecutorService executor) {
        try {
            executor.shutdown();
            boolean completed = false;
            try {
                completed = executor.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (Exception exception) {}
            if (!completed) {
                executor.shutdownNow();
            }
        }
        catch (Exception ex) {
            this.getLogger().error((Throwable)ex, "Error shutting down executor [%s]", new Object[]{id});
        }
    }

    @Override
    public void createFixedPoolExecutor(String id, int poolSize) {
        this.createExecutor(id, poolSize);
    }

    @Override
    public void createCachedPoolExecutor(String id) {
        this.createExecutor(id, -1);
    }

    @Override
    public void shutdown(String id) {
        ListeningExecutorService service = this.cache.getById(id);
        if (service != null) {
            this.shutdown(id, (ExecutorService)service);
            this.cache.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListeningScheduledExecutorService getScheduledExecutor(String id) {
        ListeningScheduledExecutorService service = null;
        ExecutorCache executorCache = this.cache;
        synchronized (executorCache) {
            ListeningExecutorService executor = this.cache.getById(id);
            service = executor instanceof ListeningScheduledExecutorService ? (ListeningScheduledExecutorService)executor : this.createScheduledExecutor(id, -1);
        }
        if (service == null) {
            throw new OseeStateException("Error creating executor [%s].", new Object[]{id});
        }
        if (service.isShutdown() || service.isTerminated()) {
            throw new OseeStateException("Error executor [%s] was previously shutdown.", new Object[]{id});
        }
        return service;
    }

    private ListeningScheduledExecutorService createScheduledExecutor(String id, int poolSize) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(String.valueOf(id) + "- [%s]").setPriority(5).build();
        ScheduledExecutorService executor = null;
        executor = poolSize > 0 ? Executors.newScheduledThreadPool(poolSize, threadFactory) : Executors.newSingleThreadScheduledExecutor(threadFactory);
        ListeningScheduledExecutorService listeningExecutor = MoreExecutors.listeningDecorator((ScheduledExecutorService)executor);
        this.cache.put(id, (ListeningExecutorService)listeningExecutor);
        return listeningExecutor;
    }

    @Override
    public void createScheduledPoolExecutor(String id, int poolSize) {
        this.createScheduledExecutor(id, poolSize);
    }

    @Override
    public <T> Future<T> scheduleAtFixedRate(String id, Callable<T> callable, long executionRate, TimeUnit timeUnit) {
        return this.scheduleAtFixedRate(id, callable, -1L, executionRate, timeUnit);
    }

    @Override
    public <T> Future<T> scheduleAtFixedRate(String id, Callable<T> callable, long startAfter, long executionRate, TimeUnit timeUnit) {
        ListeningScheduledExecutorService executor = this.getScheduledExecutor(id);
        Runnable runnable = this.asRunnable(callable);
        ListenableScheduledFuture scheduledFuture = executor.scheduleAtFixedRate(runnable, startAfter, executionRate, timeUnit);
        return scheduledFuture;
    }

    private Runnable asRunnable(final Callable<?> callable) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    callable.call();
                }
                catch (Throwable th) {
                    ExecutorAdminImpl.this.logger.error(th, "Error executing scheduled task [%s]", new Object[]{callable});
                }
            }
        };
    }
}

