/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.executor.admin;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.eclipse.osee.executor.admin.ExecutionCallback;
import org.eclipse.osee.executor.admin.ExecutorAdmin;

public final class WorkUtility {
    private static final int NUM_PARTITIONS = Math.min(4, Runtime.getRuntime().availableProcessors());

    private WorkUtility() {
    }

    public static <INPUT, OUTPUT> List<Callable<Collection<OUTPUT>>> partitionWork(Iterable<INPUT> work, PartitionFactory<INPUT, OUTPUT> factory) throws Exception {
        LinkedList<Callable<Collection<OUTPUT>>> callables = new LinkedList<Callable<Collection<OUTPUT>>>();
        int size = Iterables.size(work);
        if (size > 0) {
            Callable<Collection<OUTPUT>> worker;
            int partitionSize = Math.max(1, size / NUM_PARTITIONS);
            LinkedList<INPUT> subList = new LinkedList<INPUT>();
            int index = 0;
            Iterator<INPUT> iterator = work.iterator();
            while (iterator.hasNext()) {
                subList.add(iterator.next());
                if (index != 0 && partitionSize != 0 && index % partitionSize == 0) {
                    worker = factory.createWorker(subList);
                    callables.add(worker);
                    subList = new LinkedList();
                }
                ++index;
            }
            if (!subList.isEmpty()) {
                worker = factory.createWorker(subList);
                callables.add(worker);
            }
        }
        return callables;
    }

    public static <INPUT, OUTPUT> List<Future<Collection<OUTPUT>>> partitionAndScheduleWork(ExecutorAdmin executorAdmin, PartitionFactory<INPUT, OUTPUT> factory, Iterable<INPUT> items) throws Exception {
        return WorkUtility.partitionAndScheduleWork(executorAdmin, "default.executor", factory, items, null);
    }

    public static <INPUT, OUTPUT> List<Future<Collection<OUTPUT>>> partitionAndScheduleWork(ExecutorAdmin executorAdmin, PartitionFactory<INPUT, OUTPUT> factory, Iterable<INPUT> items, ExecutionCallback<Collection<OUTPUT>> callback) throws Exception {
        return WorkUtility.partitionAndScheduleWork(executorAdmin, "default.executor", factory, items, callback);
    }

    public static <INPUT, OUTPUT> List<Future<Collection<OUTPUT>>> partitionAndScheduleWork(ExecutorAdmin executorAdmin, String executorId, PartitionFactory<INPUT, OUTPUT> factory, Iterable<INPUT> items) throws Exception {
        return WorkUtility.partitionAndScheduleWork(executorAdmin, executorId, factory, items, null);
    }

    public static <INPUT, OUTPUT> List<Future<Collection<OUTPUT>>> partitionAndScheduleWork(ExecutorAdmin executorAdmin, String executorId, PartitionFactory<INPUT, OUTPUT> factory, Iterable<INPUT> items, ExecutionCallback<Collection<OUTPUT>> callback) throws Exception {
        LinkedList<Future<Collection<OUTPUT>>> futures = new LinkedList<Future<Collection<OUTPUT>>>();
        List<Callable<Collection<OUTPUT>>> callables = WorkUtility.partitionWork(items, factory);
        if (!callables.isEmpty()) {
            for (Callable<Collection<OUTPUT>> callable : callables) {
                Future<Collection<OUTPUT>> future = executorAdmin.schedule(executorId, callable, callback);
                futures.add(future);
            }
        }
        return futures;
    }

    public static interface PartitionFactory<INPUT, OUTPUT> {
        public Callable<Collection<OUTPUT>> createWorker(Collection<INPUT> var1);
    }
}

