/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.executor.admin;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.osee.executor.admin.HasCancellation;

public abstract class CancellableCallable<T>
implements Callable<T>,
HasCancellation {
    private final AtomicBoolean cancelled = new AtomicBoolean(false);

    protected CancellableCallable() {
    }

    @Override
    public boolean isCancelled() {
        this.cancelled.compareAndSet(false, Thread.currentThread().isInterrupted());
        return this.cancelled.get();
    }

    @Override
    public void setCancel(boolean isCancelled) {
        this.cancelled.set(isCancelled);
    }

    @Override
    public void checkForCancelled() throws CancellationException {
        if (this.isCancelled()) {
            throw new CancellationException();
        }
    }
}

