/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.workdef.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.ats.api.workdef.IAtsStateDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinition;
import org.eclipse.osee.ats.api.workdef.model.AbstractWorkDefItem;

public class WorkDefinition
extends AbstractWorkDefItem
implements IAtsWorkDefinition {
    private final List<IAtsStateDefinition> states = new ArrayList<IAtsStateDefinition>(5);
    private String id;
    private IAtsStateDefinition startState;

    public WorkDefinition(String name) {
        super(name);
        this.id = name;
    }

    @Override
    public IAtsStateDefinition getStateByName(String name) {
        for (IAtsStateDefinition state : this.states) {
            if (!state.getName().equals(name)) continue;
            return state;
        }
        return null;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WorkDefinition other = (WorkDefinition)obj;
        if (this.getId() == null) {
            if (other.getId() != null) {
                return false;
            }
            return false;
        }
        return this.getId().equals(other.getId());
    }

    @Override
    public IAtsStateDefinition getStartState() {
        return this.startState;
    }

    public void setStartState(IAtsStateDefinition startState) {
        this.startState = startState;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public IAtsStateDefinition addState(IAtsStateDefinition state) {
        IAtsStateDefinition currState = this.getStateByName(state.getName());
        if (currState != null) {
            throw new IllegalArgumentException("Can not add two states of same name");
        }
        this.states.add(state);
        return state;
    }

    @Override
    public List<IAtsStateDefinition> getStates() {
        return this.states;
    }

    public String getGuid() {
        return null;
    }
}

