/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.workdef;

import org.eclipse.osee.ats.api.workdef.IAtsWidgetDefinition;
import org.eclipse.osee.ats.api.workdef.ITransitionResult;
import org.eclipse.osee.ats.api.workdef.WidgetStatus;

public class WidgetResult
implements ITransitionResult {
    private final WidgetStatus status;
    private final IAtsWidgetDefinition widgetDef;
    private final String message;
    public static WidgetResult Valid = new WidgetResult(WidgetStatus.Valid, null, "");
    private final Exception exception;

    public WidgetResult(WidgetStatus status, IAtsWidgetDefinition widgetDef, String message) {
        this(status, widgetDef, null, message);
    }

    public WidgetResult(WidgetStatus status, IAtsWidgetDefinition widgetDef, String format, Object ... object) {
        this(status, widgetDef, null, format, object);
    }

    public WidgetResult(WidgetStatus status, IAtsWidgetDefinition widgetDef, Exception exception, String message) {
        this.status = status;
        this.widgetDef = widgetDef;
        this.exception = exception;
        this.message = message;
    }

    public WidgetResult(WidgetStatus status, IAtsWidgetDefinition widgetDef, Exception exception, String format, Object ... object) {
        this(status, widgetDef, exception, String.format(format, object));
    }

    public boolean isValid() {
        return this.status.isValid();
    }

    public WidgetStatus getStatus() {
        return this.status;
    }

    public IAtsWidgetDefinition getWidgetDef() {
        return this.widgetDef;
    }

    @Override
    public String getDetails() {
        if (this == Valid) {
            return "Valid";
        }
        return this.message;
    }

    public String toString() {
        return String.format("%s - %s - %s", new Object[]{this.status, this.widgetDef.getName(), this.message});
    }

    @Override
    public Exception getException() {
        return this.exception;
    }
}

