/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.workdef;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IAtsCreateTaskRuleDefinition;
import org.eclipse.osee.ats.api.workdef.RuleEventType;
import org.eclipse.osee.ats.api.workdef.RuleResultsEnum;
import org.eclipse.osee.ats.api.workdef.RunRuleResults;
import org.eclipse.osee.ats.api.workdef.model.RuleDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;

@XmlRootElement
public class CreateTaskRuleDefinition
extends RuleDefinition
implements IAtsCreateTaskRuleDefinition {
    private String taskWorkDef;
    private String relatedState;

    @Override
    public String getTaskWorkDef() {
        return this.taskWorkDef;
    }

    public void setTaskWorkDef(String taskWorkDef) {
        this.taskWorkDef = taskWorkDef;
    }

    @Override
    public String getRelatedState() {
        return this.relatedState;
    }

    public void setRelatedState(String relatedState) {
        this.relatedState = relatedState;
    }

    public void setRuleEvents(List<RuleEventType> ruleEvents) {
        this.ruleEvents = ruleEvents;
    }

    @Override
    public void execute(IAtsWorkItem workItem, IAtsServices atsServices, IAtsChangeSet changes, RunRuleResults ruleResults) {
        if (workItem.isTeamWorkflow()) {
            boolean createTask = true;
            for (IAtsTask task : atsServices.getTaskService().getTasks((IAtsTeamWorkflow)workItem)) {
                if (!task.getName().equals(this.name)) continue;
                createTask = false;
                break;
            }
            if (createTask) {
                HashMap<String, List<Object>> attributes = new HashMap<String, List<Object>>();
                ArrayList<String> desc = new ArrayList<String>();
                desc.add(this.description);
                attributes.put("ats.Description", desc);
                ArrayList<String> titles = new ArrayList<String>();
                titles.add(this.getTitle());
                Collection<IAtsTask> createdTasks = atsServices.getTaskService().createTasks((IAtsTeamWorkflow)workItem, titles, (List<IAtsUser>)this.assignees, new Date(), atsServices.getUserService().getCurrentUser(), this.relatedState, this.taskWorkDef, attributes, changes);
                ruleResults.addChange(workItem.getId(), RuleResultsEnum.CREATE_TASK);
                for (IAtsTask task : createdTasks) {
                    ruleResults.addChange(task.getId(), RuleResultsEnum.NEW_TASK);
                }
            }
        }
    }
}

