/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.user;

import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.eclipse.osee.ats.api.config.JaxAtsObject;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.user.IUserArtLoader;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.jdk.core.util.Collections;

@XmlRootElement
public class JaxAtsUser
extends JaxAtsObject
implements IAtsUser {
    private String userId;
    private String email;
    private ArtifactToken storeObject;
    private IUserArtLoader userArtLoader;

    @Override
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String toStringWithId() {
        return String.format("[%s]-[%d]", this.getName(), this.getUserId());
    }

    @Override
    @JsonIgnore
    public ArtifactToken getStoreObject() {
        if (this.storeObject == null && this.userArtLoader != null) {
            this.storeObject = this.userArtLoader.loadUser(this);
        }
        return this.storeObject;
    }

    @Override
    public void setStoreObject(ArtifactToken artifact) {
        this.storeObject = artifact;
    }

    @JsonIgnore
    public void setUserArtLoader(IUserArtLoader userArtLoader) {
        this.userArtLoader = userArtLoader;
    }

    public Long getId() {
        return this.getUuid();
    }

    @Override
    public IArtifactType getArtifactType() {
        return CoreArtifactTypes.User;
    }

    @Override
    public boolean isOfType(ArtifactTypeId ... artifactTypes) {
        return Collections.asHashSet((Object[])artifactTypes).contains(this.getArtifactType());
    }
}

