/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import org.eclipse.osee.ats.api.config.JaxAtsObject;
import org.eclipse.osee.ats.api.task.JaxAttribute;
import org.eclipse.osee.ats.api.task.JaxRelation;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.RelationTypeSide;

@XmlRootElement
public class JaxAtsTask
extends JaxAtsObject {
    private List<String> assigneeUserIds = new LinkedList<String>();
    private Date createdDate;
    private String createdByUserId;
    private String relatedToState;
    private String taskWorkDef;
    List<JaxAttribute> attributes = new ArrayList<JaxAttribute>();
    List<JaxRelation> relations;

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public String getCreatedByUserId() {
        return this.createdByUserId;
    }

    public void setCreatedByUserId(String createdByUserId) {
        this.createdByUserId = createdByUserId;
    }

    public String getRelatedToState() {
        return this.relatedToState;
    }

    public void setRelatedToState(String relatedToState) {
        this.relatedToState = relatedToState;
    }

    @Override
    public String toString() {
        return "JaxAtsTask [title=" + this.getName() + ", createdDate=" + this.createdDate + ", createdByUuid=" + this.createdByUserId + ", assigneeUuids=" + this.assigneeUserIds + ", relatedToState=" + this.relatedToState + "]";
    }

    public List<String> getAssigneeUserIds() {
        return this.assigneeUserIds;
    }

    public void setAssigneeUserIds(List<String> assigneeUserIds) {
        this.assigneeUserIds = assigneeUserIds;
    }

    public String getTaskWorkDef() {
        return this.taskWorkDef;
    }

    public void setTaskWorkDef(String taskWorkDef) {
        this.taskWorkDef = taskWorkDef;
    }

    public List<JaxAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<JaxAttribute> attributes) {
        this.attributes = attributes;
    }

    public void addAttributes(String attrTypeName, List<Object> values) {
        JaxAttribute attr = new JaxAttribute();
        attr.setAttrTypeName(attrTypeName);
        attr.getValues().addAll(values);
        this.attributes.add(attr);
    }

    public void addAttribute(String attrTypeName, Object value) {
        JaxAttribute attr = new JaxAttribute();
        attr.setAttrTypeName(attrTypeName);
        attr.getValues().add(value);
        this.attributes.add(attr);
    }

    public void addAttribute(AttributeTypeToken attrType, Object value) {
        this.addAttribute(attrType.getName(), value);
    }

    public void addRelation(RelationTypeSide relationSide, long ... relatedUuid) {
        JaxRelation relation = new JaxRelation();
        relation.setRelationTypeName(relationSide.getName());
        relation.setSideA(relationSide.getSide().isSideA());
        long[] lArray = relatedUuid;
        int n = relatedUuid.length;
        int n2 = 0;
        while (n2 < n) {
            long relationUuid = lArray[n2];
            relation.getRelatedUuids().add(relationUuid);
            ++n2;
        }
        this.getRelations().add(relation);
    }

    public List<JaxRelation> getRelations() {
        if (this.relations == null) {
            this.relations = new LinkedList<JaxRelation>();
        }
        return this.relations;
    }

    public void setRelations(List<JaxRelation> relations) {
        this.relations = relations;
    }
}

