/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.task;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.task.IAtsTaskService;
import org.eclipse.osee.ats.api.task.JaxAtsTask;
import org.eclipse.osee.ats.api.task.NewTaskData;
import org.eclipse.osee.ats.api.task.NewTaskDataFactory;
import org.eclipse.osee.ats.api.task.NewTaskDatas;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public abstract class AbstractAtsTaskService
implements IAtsTaskService {
    private static final String UNASSIGNED_USERID = "99999997";
    private final IAtsServices services;

    public AbstractAtsTaskService(IAtsServices services) {
        this.services = services;
    }

    @Override
    public Collection<IAtsTask> createTasks(IAtsTeamWorkflow teamWf, List<String> titles, List<IAtsUser> assignees, Date createdDate, IAtsUser createdBy, String relatedToState, String taskWorkDef, Map<String, List<Object>> attributes, String commitComment) {
        NewTaskData newTaskData = this.getNewTaskData(teamWf, titles, assignees, createdDate, createdBy, relatedToState, taskWorkDef, attributes, commitComment);
        return this.createTasks(newTaskData);
    }

    @Override
    public NewTaskData getNewTaskData(IAtsTeamWorkflow teamWf, List<String> titles, List<IAtsUser> assignees, Date createdDate, IAtsUser createdBy, String relatedToState, String taskWorkDef, Map<String, List<Object>> attributes) {
        return this.getNewTaskData(teamWf, titles, assignees, createdDate, createdBy, relatedToState, taskWorkDef, attributes, null);
    }

    @Override
    public Collection<IAtsTask> createTasks(NewTaskData newTaskData) {
        return this.createTasks(new NewTaskDatas(newTaskData));
    }

    @Override
    public NewTaskData getNewTaskData(IAtsTeamWorkflow teamWf, List<String> titles, List<IAtsUser> assignees, Date createdDate, IAtsUser createdBy, String relatedToState, String taskWorkDef, Map<String, List<Object>> attributes, String commitComment) {
        NewTaskData newTaskData = NewTaskDataFactory.get("Import Tasks from Simple List", createdBy, teamWf);
        if (createdDate == null) {
            createdDate = new Date();
        }
        for (String title : titles) {
            JaxAtsTask task = new JaxAtsTask();
            task.setName(title);
            if (assignees != null) {
                for (IAtsUser iAtsUser : assignees) {
                    task.getAssigneeUserIds().add(iAtsUser.getUserId());
                }
            } else {
                task.getAssigneeUserIds().add(UNASSIGNED_USERID);
            }
            if (Strings.isValid((String)relatedToState)) {
                task.setRelatedToState(relatedToState);
            }
            task.setCreatedByUserId(createdBy.getUserId());
            task.setCreatedDate(createdDate);
            if (Strings.isValid((String)taskWorkDef)) {
                task.setTaskWorkDef(taskWorkDef);
            }
            newTaskData.getNewTasks().add(task);
            if (attributes != null) {
                for (Map.Entry entry : attributes.entrySet()) {
                    task.addAttributes((String)entry.getKey(), (List)entry.getValue());
                }
            }
            newTaskData.setCommitComment(commitComment);
        }
        return newTaskData;
    }

    @Override
    public Collection<IAtsTask> getTasks(IAtsTeamWorkflow teamWf, IStateToken relatedToState) throws OseeCoreException {
        ArtifactId artifact = this.services.getArtifactResolver().get(teamWf);
        Conditions.checkNotNull((Object)artifact, (String)"teamWf", (String)"Can't Find Artifact matching [%s]", (Object[])new Object[]{teamWf.toString()});
        LinkedList<IAtsTask> tasks = new LinkedList<IAtsTask>();
        for (IAtsTask task : this.services.getRelationResolver().getRelated(teamWf, AtsRelationTypes.TeamWfToTask_Task, IAtsTask.class)) {
            if (!this.services.getAttributeResolver().getSoleAttributeValue(task, (AttributeTypeId)AtsAttributeTypes.RelatedToState, "").equals(relatedToState.getName())) continue;
            tasks.add(task);
        }
        return tasks;
    }

    @Override
    public Collection<? extends IAtsTask> getTasks(IAtsWorkItem workItem, IStateToken state) {
        ArtifactId artifact = this.services.getArtifactResolver().get(workItem);
        Conditions.checkNotNull((Object)artifact, (String)"workItem", (String)"Can't Find Artifact matching [%s]", (Object[])new Object[]{workItem.toString()});
        if (workItem instanceof IAtsTeamWorkflow) {
            return this.getTasks((IAtsTeamWorkflow)workItem, state);
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<IAtsTask> getTasks(IAtsTeamWorkflow teamWf) throws OseeCoreException {
        ArtifactId artifact = this.services.getArtifactResolver().get(teamWf);
        Conditions.checkNotNull((Object)artifact, (String)"teamWf", (String)"Can't Find Artifact matching [%s]", (Object[])new Object[]{teamWf.toString()});
        return this.services.getRelationResolver().getRelated(teamWf, AtsRelationTypes.TeamWfToTask_Task, IAtsTask.class);
    }

    @Override
    public Collection<IAtsTask> getTask(IAtsWorkItem workItem) throws OseeCoreException {
        if (workItem.isTeamWorkflow()) {
            return this.getTasks((IAtsTeamWorkflow)workItem);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean hasTasks(IAtsTeamWorkflow teamWf) {
        return this.services.getRelationResolver().getRelatedCount(teamWf, AtsRelationTypes.TeamWfToTask_Task) > 0;
    }

    @Override
    public boolean isRelatedToState(IAtsTask task, String stateName) {
        return this.services.getAttributeResolver().getSoleAttributeValue(task, (AttributeTypeId)AtsAttributeTypes.RelatedToState, "").equals(stateName);
    }
}

