/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.review;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.review.DecisionOption;
import org.eclipse.osee.ats.api.review.IAtsDecisionReview;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResult;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;

public class DecisionOptions {
    private final AttributeTypeId attributeType;
    private final IAtsServices services;
    private final IAtsDecisionReview decRev;

    public DecisionOptions(IAtsDecisionReview decRev, IAtsServices services) throws OseeCoreException {
        this.decRev = decRev;
        this.services = services;
        this.attributeType = AtsAttributeTypes.DecisionReviewOptions;
    }

    public AttributeTypeId getAttributeType() {
        return this.attributeType;
    }

    public Set<DecisionOption> getDecisionOptions() throws OseeCoreException {
        String decString = this.services.getAttributeResolver().getSoleAttributeValue(this.decRev, this.getAttributeType(), "");
        return DecisionOptions.getDecisionOptions(decString, this.services);
    }

    public static Set<DecisionOption> getDecisionOptions(String decisionOptions, IAtsServices services) {
        LinkedHashSet<DecisionOption> decOptions = new LinkedHashSet<DecisionOption>();
        String[] stringArray = decisionOptions.split("[\n\r]+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            DecisionOption state = new DecisionOption(services);
            String decsionOpt = stringArray[n2];
            Result result = state.setFromXml(decsionOpt);
            if (result.isFalse()) {
                services.getLogger().error(result.getText(), new Object[0]);
            } else {
                decOptions.add(state);
            }
            ++n2;
        }
        return decOptions;
    }

    public DecisionOption getDecisionOption(String name) throws OseeCoreException {
        for (DecisionOption opt : this.getDecisionOptions()) {
            if (!opt.getName().equals(name)) continue;
            return opt;
        }
        return null;
    }

    public void validateDecisionOptions(TransitionResults results) throws OseeCoreException {
        DecisionOptions.validateDecisionOptions(results, this.decRev, this.services.getAttributeResolver().getSoleAttributeValue(this.decRev, this.getAttributeType(), ""), this.services);
    }

    public static void validateDecisionOptions(TransitionResults results, IAtsDecisionReview decRev, String decisionOptions, IAtsServices services) {
        String[] stringArray = decisionOptions.split("[\n\r]+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            DecisionOption state = new DecisionOption(services);
            String decsionOpt = stringArray[n2];
            Result result = state.setFromXml(decsionOpt);
            if (result.isFalse()) {
                results.addResult(decRev, new TransitionResult("Invalid Decision Option \"" + decsionOpt + "\" " + result.getText()));
            }
            ++n2;
        }
    }

    public String toXml(Set<DecisionOption> opts) throws OseeCoreException {
        StringBuffer sb = new StringBuffer();
        for (DecisionOption opt : opts) {
            sb.append(opt.toXml());
            sb.append("\n");
        }
        return sb.toString().replaceFirst("\n$", "");
    }

    public void setDecisionOptions(String decisionOptions) throws OseeCoreException {
        this.services.getAttributeResolver().setSoleAttributeValue(this.decRev, this.getAttributeType(), this.toXml(DecisionOptions.getDecisionOptions(decisionOptions, this.services)));
    }
}

