/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.review;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;

public class DecisionOption {
    private String name;
    private Collection<IAtsUser> assignees = new HashSet<IAtsUser>();
    private boolean followupRequired;
    private final IAtsServices services;

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public DecisionOption(IAtsServices services) {
        this("", (IAtsUser)null, false, services);
    }

    public DecisionOption(String name, IAtsUser assignee, boolean followup, IAtsServices services) {
        this(name, assignee == null ? Collections.emptyList() : Collections.singleton(assignee), followup, services);
    }

    public DecisionOption(String name, Collection<IAtsUser> assignees, boolean followup, IAtsServices services) {
        this.name = name;
        this.followupRequired = followup;
        this.services = services;
        if (assignees != null) {
            this.assignees = new HashSet<IAtsUser>(assignees);
        }
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DecisionOption) {
            DecisionOption state = (DecisionOption)obj;
            return state.name.equals(this.name);
        }
        return super.equals(obj);
    }

    public Collection<IAtsUser> getAssignees() {
        return this.assignees;
    }

    public void setAssignees(Collection<IAtsUser> assignees) {
        this.assignees.clear();
        if (assignees != null) {
            this.assignees.addAll(assignees);
        }
    }

    public void setAssignee(IAtsUser assignee) {
        this.assignees.clear();
        if (assignee != null) {
            this.assignees.add(assignee);
        }
    }

    public void addAssignee(IAtsUser assignee) {
        if (assignee != null) {
            this.assignees.add(assignee);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toXml() throws OseeCoreException {
        StringBuffer sb = new StringBuffer(this.name);
        sb.append(";");
        for (IAtsUser u : this.assignees) {
            sb.append("<" + u.getUserId() + ">");
        }
        sb.append(";");
        sb.append(this.followupRequired);
        return sb.toString();
    }

    public Result setFromXml(String xml) {
        Matcher m = Pattern.compile("^(.*?);(.*?);(.*)$").matcher(xml);
        if (m.find()) {
            String toState = m.group(2).toLowerCase();
            this.name = m.group(1);
            if (this.name.equals("")) {
                return new Result("Invalid name");
            }
            if (toState.equals("followup")) {
                this.followupRequired = true;
            } else if (toState.equals("completed")) {
                this.followupRequired = false;
            } else {
                return new Result("Invalid followup string \"" + m.group(2) + "\"\nShould be followup or completed");
            }
            m = Pattern.compile("<(.*?)>").matcher(m.group(3));
            while (m.find()) {
                try {
                    this.assignees.add(this.services.getUserService().getUserById(m.group(1)));
                }
                catch (Exception ex) {
                    this.services.getLogger().error((Throwable)ex, "Error deserializing xml in DecisionOption.setFromXml", new Object[0]);
                }
            }
            if (this.followupRequired && this.assignees.isEmpty()) {
                return new Result("If followup is specified, must set assignees.\nShould be: <userid><userid>");
            }
            if (!this.followupRequired && this.assignees.size() > 0) {
                return new Result("If completed is specified, don't specify assigness.  Leave blank.\n");
            }
        } else {
            return new Result("Can't unpack decision option data => " + xml + "\n\n" + "must be in format: \"Name;(followup|completed);<userid1><userid2>\"" + "where true if followup is required; false if not.  If followup required, assignees will be userid1, userid2.");
        }
        return Result.TrueResult;
    }

    public boolean isFollowupRequired() {
        return this.followupRequired;
    }

    public void setFollowupRequired(boolean followupRequired) {
        this.followupRequired = followupRequired;
    }
}

