/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.query;

import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import org.eclipse.osee.ats.api.query.AtsSearchUserType;
import org.eclipse.osee.ats.api.query.ReleasedOption;
import org.eclipse.osee.ats.api.review.ReviewFormalType;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;

@XmlRootElement
public class AtsSearchData {
    private long uuid;
    private String searchName = "";
    private String userId = "";
    private String title = "";
    private List<StateType> stateTypes = new LinkedList<StateType>();
    private AtsSearchUserType userType;
    private List<WorkItemType> workItemTypes = new LinkedList<WorkItemType>();
    private List<Long> teamDefUuids = new LinkedList<Long>();
    private List<Long> aiUuids = new LinkedList<Long>();
    private Long versionUuid = 0L;
    private String state = "";
    private Long programUuid = 0L;
    private Long insertionUuid = 0L;
    private Long insertionActivityUuid = 0L;
    private Long workPackageUuid = 0L;
    private String colorTeam = "";
    private String namespace = "";
    private ReviewFormalType reviewType;
    private ReleasedOption releasedOption;

    public AtsSearchData() {
        this.uuid = Lib.generateUuid();
    }

    public AtsSearchData(String searchName) {
        this();
        this.searchName = searchName;
    }

    public AtsSearchData copy() {
        AtsSearchData item = new AtsSearchData(this.searchName);
        return this.copy(item);
    }

    protected AtsSearchData copy(AtsSearchData item) {
        item.uuid = this.uuid;
        item.setTitle(this.getTitle());
        item.getStateTypes().addAll(this.getStateTypes());
        item.setUserType(this.getUserType());
        item.setUserId(this.getUserId());
        item.getWorkItemTypes().addAll(this.getWorkItemTypes());
        item.setTeamDefUuids(this.getTeamDefUuids());
        item.setAiUuids(this.getAiUuids());
        item.setVersionUuid(this.getVersionUuid());
        item.setState(this.getState());
        item.setProgramUuid(this.getProgramUuid());
        item.setInsertionUuid(this.getInsertionUuid());
        item.setInsertionActivityUuid(this.getInsertionActivityUuid());
        item.setWorkPackageUuid(this.getWorkPackageUuid());
        item.setColorTeam(this.getColorTeam());
        item.setReviewType(this.getReviewType());
        return item;
    }

    public AtsSearchUserType getUserType() {
        return this.userType;
    }

    public void setUserType(AtsSearchUserType userType) {
        this.userType = userType;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSearchName() {
        return this.searchName;
    }

    public void setSearchName(String searchName) {
        this.searchName = searchName;
    }

    public long getUuid() {
        return this.uuid;
    }

    public void setUuid(long uuid) {
        Conditions.checkExpressionFailOnTrue((uuid <= 0L ? 1 : 0) != 0, (String)"Can't set uuid to 0", (Object[])new Object[0]);
        this.uuid = uuid;
    }

    public String toString() {
        return this.searchName;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public List<StateType> getStateTypes() {
        return this.stateTypes;
    }

    public void setStateTypes(List<StateType> stateTypes) {
        this.stateTypes = stateTypes;
    }

    public List<WorkItemType> getWorkItemTypes() {
        return this.workItemTypes;
    }

    public void setWorkItemTypes(List<WorkItemType> workItemTypes) {
        this.workItemTypes = workItemTypes;
    }

    public List<Long> getTeamDefUuids() {
        return this.teamDefUuids;
    }

    public void setTeamDefUuids(List<Long> teamDefUuids) {
        this.teamDefUuids = teamDefUuids;
    }

    public Long getVersionUuid() {
        return this.versionUuid;
    }

    public void setVersionUuid(Long versionUuid) {
        this.versionUuid = versionUuid;
    }

    public List<Long> getAiUuids() {
        return this.aiUuids;
    }

    public void setAiUuids(List<Long> aiUuids) {
        this.aiUuids = aiUuids;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Long getProgramUuid() {
        return this.programUuid;
    }

    public void setProgramUuid(Long programUuid) {
        this.programUuid = programUuid;
    }

    public Long getInsertionUuid() {
        return this.insertionUuid;
    }

    public void setInsertionUuid(Long insertionUuid) {
        this.insertionUuid = insertionUuid;
    }

    public Long getInsertionActivityUuid() {
        return this.insertionActivityUuid;
    }

    public void setInsertionActivityUuid(Long insertionActivityUuid) {
        this.insertionActivityUuid = insertionActivityUuid;
    }

    public Long getWorkPackageUuid() {
        return this.workPackageUuid;
    }

    public void setWorkPackageUuid(Long workPackageUuid) {
        this.workPackageUuid = workPackageUuid;
    }

    public String getColorTeam() {
        return this.colorTeam;
    }

    public void setColorTeam(String colorTeam) {
        this.colorTeam = colorTeam;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public ReviewFormalType getReviewType() {
        return this.reviewType;
    }

    public void setReviewType(ReviewFormalType reviewType) {
        this.reviewType = reviewType;
    }

    public ReleasedOption getReleasedOption() {
        return this.releasedOption;
    }

    public void setReleasedOption(ReleasedOption releasedOption) {
        this.releasedOption = releasedOption;
    }
}

