/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.eclipse.osee.ats.api.config.AtsConfiguration;
import org.eclipse.osee.ats.api.config.AtsViews;
import org.eclipse.osee.ats.api.config.IWorkDefinitionStringProvider;
import org.eclipse.osee.ats.api.config.JaxActionableItem;
import org.eclipse.osee.ats.api.config.JaxTeamDefinition;
import org.eclipse.osee.ats.api.config.JaxVersion;
import org.eclipse.osee.ats.api.user.JaxAtsUser;
import org.eclipse.osee.ats.api.util.ColorColumns;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;

@XmlRootElement
public class AtsConfigurations
implements IWorkDefinitionStringProvider {
    private List<AtsConfiguration> configs = new ArrayList<AtsConfiguration>();
    private AtsViews views = new AtsViews();
    private ColorColumns colorColumns = new ColorColumns();
    List<JaxAtsUser> users = new ArrayList<JaxAtsUser>();
    List<Long> atsAdmins = new ArrayList<Long>();
    Long topActionableItem;
    Long topTeamDefinition;
    List<JaxVersion> versions = new ArrayList<JaxVersion>();
    private Collection<String> validStateNames = new ArrayList<String>();
    private Map<String, String> workDefIdToWorkDef = new HashMap<String, String>();
    private Map<Long, JaxActionableItem> idToAi = new HashMap<Long, JaxActionableItem>();
    private Map<Long, JaxTeamDefinition> idToTeamDef = new HashMap<Long, JaxTeamDefinition>();
    private Map<Long, JaxVersion> idToVersion = new HashMap<Long, JaxVersion>();

    public List<AtsConfiguration> getConfigs() {
        return this.configs;
    }

    public AtsViews getViews() {
        return this.views;
    }

    public void setViews(AtsViews views) {
        this.views = views;
    }

    public ColorColumns getColorColumns() {
        return this.colorColumns;
    }

    public void setColorColumns(ColorColumns colorColumns) {
        this.colorColumns = colorColumns;
    }

    public List<JaxAtsUser> getUsers() {
        return this.users;
    }

    public void setUsers(List<JaxAtsUser> users) {
        this.users = users;
    }

    public Collection<String> getValidStateNames() {
        return this.validStateNames;
    }

    public void setConfigs(List<AtsConfiguration> configs) {
        this.configs = configs;
    }

    public void setValidStateNames(Collection<String> validStateNames) {
        this.validStateNames = validStateNames;
    }

    public String getAtsAdminsStr() {
        return Collections.toString((String)",", this.atsAdmins);
    }

    @JsonIgnore
    public List<Long> getAtsAdmins() {
        return this.atsAdmins;
    }

    public void setAtsAdminsStr(String atsAdmins) {
        this.parseStringOfLongs(this.atsAdmins, atsAdmins);
    }

    private void parseStringOfLongs(List<Long> uuids, String strOfLongs) {
        if (Strings.isValid((String)strOfLongs)) {
            String[] stringArray = strOfLongs.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String uuid = stringArray[n2];
                uuids.add(Long.valueOf(uuid));
                ++n2;
            }
        }
    }

    @Override
    public Map<String, String> getWorkDefIdToWorkDef() {
        return this.workDefIdToWorkDef;
    }

    public void setWorkDefIdToWorkDef(Map<String, String> workDefIdToWorkDef) {
        this.workDefIdToWorkDef = workDefIdToWorkDef;
    }

    public Map<Long, JaxActionableItem> getIdToAi() {
        return this.idToAi;
    }

    public void setIdToAi(Map<Long, JaxActionableItem> idToAi) {
        this.idToAi = idToAi;
    }

    public Map<Long, JaxTeamDefinition> getIdToTeamDef() {
        return this.idToTeamDef;
    }

    public void setIdToTeamDef(Map<Long, JaxTeamDefinition> idToTeamDef) {
        this.idToTeamDef = idToTeamDef;
    }

    public Map<Long, JaxVersion> getIdToVersion() {
        return this.idToVersion;
    }

    public void setIdToVersion(Map<Long, JaxVersion> idToVersion) {
        this.idToVersion = idToVersion;
    }

    public Long getTopActionableItem() {
        return this.topActionableItem;
    }

    public void setTopActionableItem(Long topActionableItem) {
        this.topActionableItem = topActionableItem;
    }

    public Long getTopTeamDefinition() {
        return this.topTeamDefinition;
    }

    public void setTopTeamDefinition(Long topTeamDefinition) {
        this.topTeamDefinition = topTeamDefinition;
    }

    public void addTeamDef(JaxTeamDefinition teamDef) {
        this.idToTeamDef.put(teamDef.getUuid(), teamDef);
    }

    public void addAi(JaxActionableItem ai) {
        this.idToAi.put(ai.getUuid(), ai);
    }

    public void addVersion(JaxVersion version) {
        this.idToVersion.put(version.getUuid(), version);
    }

    public void addWorkDefinition(String id, String workDefStr) {
        this.workDefIdToWorkDef.put(id, workDefStr);
    }
}

