/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.agile;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.osee.ats.api.agile.AgileItem;
import org.eclipse.osee.ats.api.agile.JaxAgileBacklog;
import org.eclipse.osee.ats.api.agile.JaxAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.JaxAgileItem;
import org.eclipse.osee.ats.api.agile.JaxAgileSprint;
import org.eclipse.osee.ats.api.agile.JaxAgileTeam;
import org.eclipse.osee.ats.api.agile.JaxNewAgileBacklog;
import org.eclipse.osee.ats.api.agile.JaxNewAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.JaxNewAgileSprint;
import org.eclipse.osee.ats.api.agile.JaxNewAgileTeam;
import org.eclipse.osee.ats.api.workflow.JaxAtsObjects;

@Path(value="agile")
public interface AgileEndpointApi {
    @GET
    public String get();

    @GET
    @Path(value="team")
    @Produces(value={"application/json"})
    public List<JaxAgileTeam> team() throws Exception;

    @GET
    @Path(value="team/{teamUuid}")
    @Produces(value={"application/json"})
    public JaxAgileTeam getTeam(@PathParam(value="teamUuid") long var1);

    @GET
    @Path(value="team/{teamUuid}/feature")
    @Produces(value={"application/json"})
    public List<JaxAgileFeatureGroup> getFeatureGroups(@PathParam(value="teamUuid") long var1);

    @GET
    @Path(value="team/{teamUuid}/feature/{featureUuid}")
    @Produces(value={"application/json"})
    public JaxAgileFeatureGroup getFeatureGroup(long var1, long var3);

    @GET
    @Path(value="team/{teamUuid}/backlog")
    @Produces(value={"application/json"})
    public JaxAgileBacklog getBacklog(@PathParam(value="teamUuid") long var1);

    @GET
    @Path(value="team/{teamUuid}/backlog/item")
    @Produces(value={"application/json"})
    public List<AgileItem> getBacklogItems(@PathParam(value="teamUuid") long var1);

    @GET
    @Path(value="team/{teamUuid}/sprint")
    @Produces(value={"application/json"})
    public List<JaxAgileSprint> getSprints(@PathParam(value="teamUuid") long var1);

    @GET
    @Path(value="team/{teamUuid}/sprint/{sprintUuid}/summary")
    @Produces(value={"text/html"})
    public Response getSprintSummary(@PathParam(value="teamUuid") long var1, @PathParam(value="sprintUuid") long var3);

    @GET
    @Path(value="team/{teamUuid}/sprint/{sprintUuid}/burndown")
    @Produces(value={"application/json"})
    public Response getSprintBurndown(@PathParam(value="teamUuid") long var1, @PathParam(value="sprintUuid") long var3);

    @GET
    @Path(value="team/{teamUuid}/sprint/{sprintUuid}/burndown/ui")
    @Produces(value={"text/html"})
    public Response getSprintBurndownUi(@PathParam(value="teamUuid") long var1, @PathParam(value="sprintUuid") long var3);

    @GET
    @Path(value="team/{teamUuid}/sprint/{sprintUuid}/world")
    @Produces(value={"application/json"})
    public JaxAtsObjects getSprintItemsAsJax(@PathParam(value="teamUuid") long var1, @PathParam(value="sprintUuid") long var3);

    @GET
    @Path(value="team/{teamUuid}/sprint/{sprintUuid}/world/ui")
    @Produces(value={"text/html"})
    public Response getSprintItemsUI(@PathParam(value="teamUuid") long var1, @PathParam(value="sprintUuid") long var3);

    @GET
    @Path(value="team/{teamUuid}/sprint/{sprintUuid}/world/ui/{customizeGuid}")
    @Produces(value={"text/html"})
    public Response getSprintItemsUICustomized(@PathParam(value="teamUuid") long var1, @PathParam(value="sprintUuid") long var3, @PathParam(value="customizeGuid") String var5);

    @POST
    @Path(value="team")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createTeam(JaxNewAgileTeam var1);

    @PUT
    @Path(value="team")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateTeam(JaxAgileTeam var1);

    @POST
    @Path(value="team/{teamUuid}/feature")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createFeatureGroup(@PathParam(value="teamUuid") long var1, JaxNewAgileFeatureGroup var3);

    @POST
    @Path(value="team/{teamUuid}/sprint")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createSprint(@PathParam(value="teamUuid") long var1, JaxNewAgileSprint var3);

    @POST
    @Path(value="team/{teamUuid}/backlog")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createBacklog(@PathParam(value="teamUuid") long var1, JaxNewAgileBacklog var3);

    @PUT
    @Path(value="team/{teamUuid}/backlog")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateBacklog(long var1, JaxAgileBacklog var3);

    @PUT
    @Path(value="item/{itemId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateItem(@PathParam(value="itemId") long var1, JaxAgileItem var3);

    @PUT
    @Path(value="item")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateItems(JaxAgileItem var1);

    @DELETE
    @Path(value="team/{teamUuid}/feature/{featureUuid}")
    public Response deleteFeatureGroup(@PathParam(value="teamUuid") long var1, @PathParam(value="featureUuid") long var3);

    @DELETE
    @Path(value="team/{teamUuid}/sprint/{sprintUuid}")
    public Response deleteSprint(@PathParam(value="teamUuid") long var1, @PathParam(value="sprintUuid") long var3);

    @DELETE
    @Path(value="team/{teamUuid}")
    public Response deleteTeam(@PathParam(value="teamUuid") long var1);

    @PUT
    @Path(value="item/{itemId}/feature")
    public Response addFeatureGroup(@PathParam(value="itemId") long var1, String var3);

    @PUT
    @Path(value="item/{itemId}/unplanned")
    public Response setUnPlanned(@PathParam(value="itemId") long var1, boolean var3);

    @PUT
    @Path(value="item/{itemId}/points")
    public Response setPoints(@PathParam(value="itemId") long var1, String var3);

    @GET
    @Path(value="team/{teamUuid}/sprint/{sprintUuid}/burndownExcel")
    @Produces(value={"application/json"})
    public Response getSprintBurndownExcel(@PathParam(value="teamUuid") long var1, @PathParam(value="sprintUuid") long var3);
}

