/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.vcast.model;

import java.util.Collection;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.vcast.VCastDataStore;
import org.eclipse.osee.vcast.model.VCastProjectFile;
import org.eclipse.osee.vcast.model.VCastTableData;

public class VCastProjectFileTable
implements VCastTableData<VCastProjectFile> {
    @Override
    public String getName() {
        return "project_files";
    }

    @Override
    public String[] getColumns() {
        return new String[]{"project_id", "source_file_id", "instrumented_file_id", "timestamp", "build_md5sum"};
    }

    @Override
    public Collection<VCastProjectFile> getRows(VCastDataStore dataStore) throws OseeCoreException {
        return dataStore.getAllProjectFiles();
    }

    @Override
    public Object[] toRow(VCastProjectFile data) {
        Integer projectId = data.getProjectId();
        Integer sourceFileId = data.getSourceFileId();
        Integer instrumentedFileId = data.getInstrumentedFileId();
        Integer timestamp = data.getTimestamp();
        String buildMd5sum = data.getBuildMd5Sum();
        return new Object[]{projectId, sourceFileId, instrumentedFileId, timestamp, buildMd5sum};
    }
}

