/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.vcast;

import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.vcast.model.ICoverageUnitFileContentsLoader;

public class VCastLisFileParser
implements ICoverageUnitFileContentsLoader {
    private static final String lis = ".lis";
    private static final String LIS = ".LIS";
    private static final Pattern sourceLinePattern = Pattern.compile("^[0-9]+ [0-9]+(.*?)$");
    private static final Pattern exceptionPattern = Pattern.compile("^\\s+EXCEPTION\\s*$");
    private static final Pattern endMethodPattern = Pattern.compile("^\\s*END\\s+(.*);\\s*$");
    private final String lisFileName;
    private final String vCastDir;
    private boolean populated = false;
    private String fileText = null;
    private String[] lisFileLines;

    public VCastLisFileParser(String lisFileName, String vCastDir) {
        this.lisFileName = lisFileName;
        this.vCastDir = vCastDir;
    }

    private synchronized void ensurePopulated() {
        if (!this.populated) {
            this.populated = true;
            String lisFilePathName = String.valueOf(this.vCastDir) + File.separator + this.lisFileName;
            File lisFile = new File(this.vCastDir);
            boolean foundFile = false;
            String[] stringArray = lisFile.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                if (file.equalsIgnoreCase(this.lisFileName)) {
                    lisFile = new File(String.valueOf(this.vCastDir) + File.separator + file);
                    foundFile = true;
                    break;
                }
                ++n2;
            }
            if (!foundFile) {
                throw new OseeArgumentException(String.format("VectorCast *.LIS file doesn't exist [%s]", lisFilePathName), new Object[0]);
            }
            try {
                this.fileText = Lib.fileToString((File)lisFile);
            }
            catch (IOException iOException) {
                throw new OseeArgumentException(String.format("IO Exception trying to read file [%s]", lisFilePathName), new Object[0]);
            }
            this.lisFileLines = this.fileText.split("\n");
        }
    }

    public Pair<String, Boolean> getSourceCodeForLine(Integer method, Integer executionLine) {
        this.ensurePopulated();
        String startsWith = method + " " + executionLine + " ";
        boolean exceptionLine = false;
        String[] stringArray = this.lisFileLines;
        int n = this.lisFileLines.length;
        int n2 = 0;
        while (n2 < n) {
            Matcher m;
            String line = stringArray[n2];
            if (line.startsWith(startsWith)) {
                m = sourceLinePattern.matcher(line);
                String lineCode = "";
                lineCode = m.find() ? m.group(1) : "Error parsing *.LIS file";
                return new Pair((Object)lineCode, (Object)exceptionLine);
            }
            m = exceptionPattern.matcher(line);
            if (m.find()) {
                exceptionLine = true;
            } else {
                m = endMethodPattern.matcher(line);
                if (m.find()) {
                    exceptionLine = false;
                }
            }
            ++n2;
        }
        return null;
    }

    @Override
    public String getText() {
        this.ensurePopulated();
        return this.fileText;
    }
}

