/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.account.admin.internal.oauth;

import com.google.common.io.InputSupplier;
import com.google.gson.GsonBuilder;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IOseeBranch;
import org.eclipse.osee.framework.core.data.OrcsTypesData;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreTupleTypes;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.jdk.core.type.LazyObject;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.account.admin.internal.oauth.ClientStorage;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class ClientStorageProvider
extends LazyObject<ClientStorage> {
    private static final String OAUTH_TYPES_DEFITIONS = "types/OseeTypes_OAuth.osee";
    private Log logger;
    private OrcsApi orcsApi;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    protected FutureTask<ClientStorage> createLoaderTask() {
        Callable<ClientStorage> callable = new Callable<ClientStorage>(){

            @Override
            public ClientStorage call() throws Exception {
                GsonBuilder builder = new GsonBuilder();
                IOseeBranch storageBranch = CoreBranches.COMMON;
                ClientStorage clientStorage = new ClientStorage(ClientStorageProvider.this.logger, builder, ClientStorageProvider.this.orcsApi, (BranchId)storageBranch);
                if (!clientStorage.typesExist()) {
                    InputSupplier newTypesSupplier = ClientStorageProvider.this.newTypesSupplier();
                    ArtifactReadable typeArt = (ArtifactReadable)clientStorage.storeTypes((InputSupplier<? extends InputStream>)newTypesSupplier);
                    TransactionBuilder tx = ClientStorageProvider.this.orcsApi.getTransactionFactory().createTransaction((BranchId)CoreBranches.COMMON, (ArtifactId)SystemUser.OseeSystem, "Add OseeTypeDef OAuth Tuple to Common Branch");
                    tx.addTuple2(CoreTupleTypes.OseeTypeDef, (Object)OrcsTypesData.OSEE_TYPE_VERSION, (Object)((AttributeId)typeArt.getAttributes((AttributeTypeId)CoreAttributeTypes.UriGeneralStringData).iterator().next()));
                    tx.commit();
                }
                return clientStorage;
            }
        };
        return new FutureTask<ClientStorage>(callable);
    }

    private InputSupplier<InputStream> newTypesSupplier() {
        return new InputSupplier<InputStream>(){

            public InputStream getInput() throws IOException {
                URL resource = this.getClass().getResource(ClientStorageProvider.OAUTH_TYPES_DEFITIONS);
                return new BufferedInputStream(resource.openStream());
            }
        };
    }
}

