/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.account.admin.internal.oauth;

import com.google.common.io.InputSupplier;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseePrincipal;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.jaxrs.server.security.OAuthClient;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.account.admin.internal.oauth.ClientArtifact;
import org.eclipse.osee.orcs.account.admin.internal.oauth.OAuthClientCredential;
import org.eclipse.osee.orcs.account.admin.internal.oauth.OAuthTypes;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.eclipse.osee.orcs.transaction.TransactionFactory;

public class ClientStorage {
    private final Log logger;
    private final GsonBuilder builder;
    private final OrcsApi orcsApi;
    private final BranchId storageBranch;

    public ClientStorage(Log logger, GsonBuilder builder, OrcsApi orcsApi, BranchId storageBranch) {
        this.logger = logger;
        this.builder = builder;
        this.orcsApi = orcsApi;
        this.storageBranch = storageBranch;
    }

    private BranchId getBranch() {
        return this.storageBranch;
    }

    private int idToInt(long uuid) {
        return Long.valueOf(uuid).intValue();
    }

    private QueryBuilder newQuery() {
        QueryFactory queryFactory = this.orcsApi.getQueryFactory();
        return queryFactory.fromBranch(this.getBranch());
    }

    private ArtifactReadable getAuthorById(long authorId) {
        ArtifactReadable author;
        if (authorId > -1L) {
            int artId = this.idToInt(authorId);
            author = (ArtifactReadable)((QueryBuilder)this.newQuery().andUuid((long)artId)).getResults().getExactlyOne();
        } else {
            author = this.getSystemUser();
        }
        return author;
    }

    private ArtifactReadable getSystemUser() {
        return (ArtifactReadable)((QueryBuilder)this.newQuery().andIds((ArtifactId)SystemUser.OseeSystem)).getResults().getExactlyOne();
    }

    private TransactionBuilder newTransaction(OseePrincipal principal, String comment) {
        long authorId = principal != null ? (Long)principal.getGuid() : -1L;
        ArtifactReadable author = this.getAuthorById(authorId);
        TransactionFactory transactionFactory = this.orcsApi.getTransactionFactory();
        return transactionFactory.createTransaction(this.getBranch(), (ArtifactId)author, comment);
    }

    public ResultSet<ArtifactReadable> getClientByApplicationId(long applicationId) {
        int id = this.idToInt(applicationId);
        return ((QueryBuilder)((QueryBuilder)this.newQuery().andIsOfType(new ArtifactTypeId[]{OAuthTypes.OAUTH_CLIENT})).andUuid((long)id)).getResults();
    }

    public ResultSet<ArtifactReadable> getClientByClientGuid(String guid) {
        return ((QueryBuilder)((QueryBuilder)this.newQuery().andIsOfType(new ArtifactTypeId[]{OAuthTypes.OAUTH_CLIENT})).andGuid(guid)).getResults();
    }

    public ResultSet<ArtifactReadable> getClientByClientUuid(Long uuid) {
        return ((QueryBuilder)((QueryBuilder)this.newQuery().andIsOfType(new ArtifactTypeId[]{OAuthTypes.OAUTH_CLIENT})).andUuid(uuid.longValue())).getResults();
    }

    public boolean exists(Long uuid) {
        return ((QueryBuilder)((QueryBuilder)this.newQuery().andIsOfType(new ArtifactTypeId[]{OAuthTypes.OAUTH_CLIENT})).andUuid(uuid.longValue())).getCount() > 0;
    }

    public ArtifactId insert(OseePrincipal principal, OAuthClient data) {
        TransactionBuilder tx = this.newTransaction(principal, "Create OAuth Client");
        ArtifactToken artId = tx.createArtifact(OAuthTypes.OAUTH_CLIENT, data.getApplicationName(), (String)data.getGuid());
        this.txSetClient(tx, (ArtifactId)artId, data);
        tx.commit();
        return artId;
    }

    public void update(OseePrincipal principal, OAuthClient data) {
        ArtifactId artId = ArtifactId.valueOf((long)data.getClientUuid());
        TransactionBuilder tx = this.newTransaction(principal, "Update OAuth Client");
        tx.setName(artId, data.getApplicationName());
        this.txSetClient(tx, artId, data);
        tx.commit();
    }

    private void txSetClient(TransactionBuilder tx, ArtifactId artId, OAuthClient data) {
        tx.setSoleAttributeFromString(artId, (AttributeTypeId)CoreAttributeTypes.Description, data.getApplicationDescription());
        tx.setSoleAttributeFromString(artId, (AttributeTypeId)OAuthTypes.OAUTH_CLIENT_WEBSITE_URI, data.getApplicationWebUri());
        tx.setSoleAttributeFromString(artId, (AttributeTypeId)OAuthTypes.OAUTH_CLIENT_LOGO_URI, data.getApplicationLogoUri());
        tx.setSoleAttributeValue(artId, (AttributeTypeId)OAuthTypes.OAUTH_CLIENT_IS_CONFIDENTIAL, (Object)data.isConfidential());
        tx.setAttributesFromStrings(artId, (AttributeTypeId)OAuthTypes.OAUTH_CLIENT_AUTHORIZED_AUDIENCE, (Collection)data.getRegisteredAudiences());
        tx.setAttributesFromStrings(artId, (AttributeTypeId)OAuthTypes.OAUTH_CLIENT_AUTHORIZED_GRANT_TYPE, (Collection)data.getAllowedGrantTypes());
        tx.setAttributesFromStrings(artId, (AttributeTypeId)OAuthTypes.OAUTH_CLIENT_AUTHORIZED_REDIRECT_URI, (Collection)data.getRedirectUris());
        tx.setAttributesFromStrings(artId, (AttributeTypeId)OAuthTypes.OAUTH_CLIENT_AUTHORIZED_SCOPE, (Collection)data.getRegisteredScopes());
        InputSupplier supplier = data.getApplicationLogoSupplier();
        if (supplier != null) {
            try {
                tx.setAttributesFromValues(artId, (AttributeTypeId)CoreAttributeTypes.ImageContent, (Object[])new InputStream[]{(InputStream)supplier.getInput()});
            }
            catch (Exception ex) {
                throw new OseeCoreException((Throwable)ex, "Error reading logo data for [%s]", new Object[]{artId});
            }
        }
        Map props = data.getProperties();
        Gson gson = this.builder.create();
        String json = gson.toJson((Object)props);
        tx.setSoleAttributeValue(artId, (AttributeTypeId)OAuthTypes.OAUTH_CLIENT_PROPERTIES, (Object)json);
    }

    public void delete(OseePrincipal principal, OAuthClient data) {
        ArtifactId artId = ArtifactId.valueOf((long)data.getClientUuid());
        TransactionBuilder tx = this.newTransaction(principal, "Delete OAuth Client");
        tx.deleteArtifact(artId);
        tx.commit();
    }

    private ResultSet<ArtifactReadable> getOAuthTypesDefinition() throws OseeCoreException {
        return ((QueryBuilder)((QueryBuilder)this.newQuery().andUuid(OAuthTypes.OAUTH_TYPES.getUuid().longValue())).andTypeEquals(new ArtifactTypeId[]{OAuthTypes.OAUTH_TYPES.getArtifactType()})).getResults();
    }

    public ArtifactId storeTypes(InputSupplier<? extends InputStream> resource) {
        TransactionBuilder tx = this.newTransaction(null, "Initialize OAuth Type Definitions");
        ArtifactToken artifactId = tx.createArtifact(OAuthTypes.OAUTH_TYPES);
        InputStream stream = null;
        try {
            try {
                stream = (InputStream)resource.getInput();
                tx.setSoleAttributeFromStream((ArtifactId)artifactId, (AttributeTypeId)CoreAttributeTypes.UriGeneralStringData, stream);
            }
            catch (IOException ex) {
                throw new OseeCoreException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            Lib.close(stream);
            throw throwable;
        }
        Lib.close((Closeable)stream);
        tx.commit();
        this.reloadTypes();
        return artifactId;
    }

    private void reloadTypes() {
        this.orcsApi.getOrcsTypes().invalidateAll();
    }

    public boolean typesExist() {
        boolean result = false;
        try {
            result = !this.getOAuthTypesDefinition().isEmpty();
        }
        catch (OseeCoreException ex) {
            this.logger.warn((Throwable)ex, "Error checking for OAuth Types", new Object[0]);
        }
        return result;
    }

    public OAuthClient newClient(ArtifactReadable artifact, OAuthClientCredential credential) {
        return new ClientArtifact(this.builder, artifact, credential);
    }
}

