/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.account.admin.internal.oauth;

import com.google.common.io.InputSupplier;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.BaseIdentity;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jaxrs.server.security.OAuthClient;
import org.eclipse.osee.orcs.account.admin.internal.oauth.OAuthClientCredential;
import org.eclipse.osee.orcs.account.admin.internal.oauth.OAuthTypes;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class ClientArtifact
extends BaseIdentity<String>
implements OAuthClient,
InputSupplier<InputStream> {
    private final GsonBuilder builder;
    private final ArtifactReadable artifact;
    private final OAuthClientCredential credential;

    public ClientArtifact(GsonBuilder builder, ArtifactReadable artifact, OAuthClientCredential credential) {
        super((Object)((String)artifact.getGuid()));
        this.builder = builder;
        this.credential = credential;
        this.artifact = artifact;
    }

    public long getClientUuid() {
        return this.credential.getClientId();
    }

    public long getSubjectId() {
        return this.credential.getSubjectId();
    }

    public String getApplicationName() {
        return this.artifact.getName();
    }

    public String getApplicationDescription() {
        return (String)this.artifact.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Description);
    }

    public String getApplicationWebUri() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeId)OAuthTypes.OAUTH_CLIENT_WEBSITE_URI);
    }

    public String getApplicationLogoUri() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeId)OAuthTypes.OAUTH_CLIENT_LOGO_URI);
    }

    public boolean isConfidential() {
        return (Boolean)this.artifact.getSoleAttributeValue((AttributeTypeId)OAuthTypes.OAUTH_CLIENT_IS_CONFIDENTIAL);
    }

    public List<String> getAllowedGrantTypes() {
        return this.artifact.getAttributeValues((AttributeTypeId)OAuthTypes.OAUTH_CLIENT_AUTHORIZED_GRANT_TYPE);
    }

    public List<String> getRedirectUris() {
        return this.artifact.getAttributeValues((AttributeTypeId)OAuthTypes.OAUTH_CLIENT_AUTHORIZED_REDIRECT_URI);
    }

    public List<String> getRegisteredScopes() {
        return this.artifact.getAttributeValues((AttributeTypeId)OAuthTypes.OAUTH_CLIENT_AUTHORIZED_SCOPE);
    }

    public List<String> getRegisteredAudiences() {
        return this.artifact.getAttributeValues((AttributeTypeId)OAuthTypes.OAUTH_CLIENT_AUTHORIZED_AUDIENCE);
    }

    public Map<String, String> getProperties() {
        Map toReturn = Collections.emptyMap();
        String data = (String)this.artifact.getSoleAttributeValue((AttributeTypeId)OAuthTypes.OAUTH_CLIENT_PROPERTIES, null);
        if (Strings.isValid((String)data)) {
            Gson gson = this.builder.create();
            Type typeOfHashMap = new TypeToken<Map<String, String>>(){}.getType();
            toReturn = (Map)gson.fromJson(data, typeOfHashMap);
        }
        return toReturn;
    }

    public String getClientId() {
        return this.credential.getClientKey();
    }

    public String getClientSecret() {
        return this.credential.getClientSecret();
    }

    public List<String> getApplicationCertificates() {
        return this.credential.getClientCertificates();
    }

    public boolean hasApplicationLogoSupplier() {
        return this.artifact.getAttributeCount((AttributeTypeId)CoreAttributeTypes.ImageContent) > 0;
    }

    public InputSupplier<InputStream> getApplicationLogoSupplier() {
        return this;
    }

    public InputStream getInput() {
        return (InputStream)this.artifact.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.ImageContent);
    }
}

