/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.account.admin.internal;

import java.util.Date;
import org.eclipse.osee.account.admin.Account;
import org.eclipse.osee.account.admin.AccountPreferences;
import org.eclipse.osee.account.admin.AccountSession;
import org.eclipse.osee.account.admin.SubscriptionGroup;
import org.eclipse.osee.account.rest.model.AccountWebPreferences;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.type.ResultSetTransform;
import org.eclipse.osee.framework.jdk.core.type.ResultSets;
import org.eclipse.osee.orcs.account.admin.internal.AccountArtifact;
import org.eclipse.osee.orcs.account.admin.internal.AccountPreferencesArtifact;
import org.eclipse.osee.orcs.account.admin.internal.AccountSessionImpl;
import org.eclipse.osee.orcs.account.admin.internal.AccountSubscriptionGroupImpl;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class AccountFactory {
    private final ResultSetTransform.Function<String, ArtifactReadable, Account> function1 = new ArtifactToAccount();
    private final ResultSetTransform.Function<String, ArtifactReadable, AccountPreferences> function2 = new ArtifactToAccountPreferences();
    private final ResultSetTransform.Function<String, ArtifactReadable, SubscriptionGroup> function3 = new ArtifactToAccountSubscriptionGroup();

    public ResultSet<Account> newAccountResultSet(ResultSet<ArtifactReadable> results) {
        return ResultSets.transform(results, this.function1);
    }

    public ResultSet<AccountPreferences> newAccountPreferencesResultSet(ResultSet<ArtifactReadable> results) {
        return ResultSets.transform(results, this.function2);
    }

    public Account newAccount(ArtifactReadable artifact) {
        AccountPreferences preferences = this.newAccountPreferences(artifact);
        AccountWebPreferences webPreferences = this.newAccountWebPreferences(artifact);
        return new AccountArtifact((String)artifact.getGuid(), artifact, preferences, webPreferences);
    }

    public AccountPreferences newAccountPreferences(ArtifactReadable artifact) {
        String id = (String)artifact.getGuid();
        return new AccountPreferencesArtifact(id, artifact);
    }

    public AccountWebPreferences newAccountWebPreferences(ArtifactReadable artifact) {
        String webPreferencesJson = artifact.getSoleAttributeAsString((AttributeTypeId)CoreAttributeTypes.WebPreferences, "{}");
        return new AccountWebPreferences(webPreferencesJson, artifact.getName());
    }

    public AccountSession newAccountSession(ArtifactId accountId, String sessionToken, String accessedFrom, String accessDetails) {
        Date currentDate = new Date();
        return this.newAccountSession(accountId, sessionToken, currentDate, currentDate, accessedFrom, accessDetails);
    }

    public AccountSession newAccountSession(ArtifactId accountId, String sessionToken, Date createdOn, Date lastAccessedOn, String accessedFrom, String accessDetails) {
        AccountSessionImpl session = new AccountSessionImpl();
        session.setAccountId(accountId.getUuid());
        session.setSessionToken(sessionToken);
        session.setCreatedOn(createdOn);
        session.setLastAccessedOn(lastAccessedOn);
        session.setAccessDetails(accessDetails);
        session.setAccessedFrom(accessedFrom);
        return session;
    }

    public SubscriptionGroup newAccountSubscriptionGroup(ArtifactReadable source) {
        return new AccountSubscriptionGroupImpl(source);
    }

    public ResultSet<SubscriptionGroup> newAccountSubscriptionGroupResultSet(ResultSet<ArtifactReadable> results) {
        return ResultSets.transform(results, this.function3);
    }

    private class ArtifactToAccount
    implements ResultSetTransform.Function<String, ArtifactReadable, Account> {
        private ArtifactToAccount() {
        }

        public Account apply(ArtifactReadable source) {
            return AccountFactory.this.newAccount(source);
        }
    }

    private class ArtifactToAccountPreferences
    implements ResultSetTransform.Function<String, ArtifactReadable, AccountPreferences> {
        private ArtifactToAccountPreferences() {
        }

        public AccountPreferences apply(ArtifactReadable source) {
            return AccountFactory.this.newAccountPreferences(source);
        }
    }

    private class ArtifactToAccountSubscriptionGroup
    implements ResultSetTransform.Function<String, ArtifactReadable, SubscriptionGroup> {
        private ArtifactToAccountSubscriptionGroup() {
        }

        public SubscriptionGroup apply(ArtifactReadable source) {
            return AccountFactory.this.newAccountSubscriptionGroup(source);
        }
    }
}

