/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.account.admin.internal;

import org.eclipse.osee.account.admin.Account;
import org.eclipse.osee.account.admin.AccountPreferences;
import org.eclipse.osee.account.rest.model.AccountWebPreferences;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.BaseIdentity;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class AccountArtifact
extends BaseIdentity<String>
implements Account {
    private static final String NOT_AVAILABLE = "N/A";
    private final ArtifactReadable artifact;
    private final AccountPreferences preferences;
    private final AccountWebPreferences webPreferences;

    public AccountArtifact(String uuid, ArtifactReadable artifact, AccountPreferences preferences, AccountWebPreferences webPreferences) {
        super((Object)((String)artifact.getGuid()));
        this.artifact = artifact;
        this.preferences = preferences;
        this.webPreferences = webPreferences;
    }

    public Long getId() {
        return this.artifact.getUuid();
    }

    public boolean isActive() {
        return (Boolean)this.artifact.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Active, (Object)false);
    }

    public String getName() {
        return (String)this.artifact.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Name, (Object)NOT_AVAILABLE);
    }

    public String getUserName() {
        return (String)this.artifact.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.UserId, (Object)NOT_AVAILABLE);
    }

    public String getEmail() {
        return (String)this.artifact.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Email, (Object)NOT_AVAILABLE);
    }

    public AccountWebPreferences getWebPreferences() {
        return this.webPreferences;
    }

    public AccountPreferences getPreferences() {
        return this.preferences;
    }

    public String toString() {
        return "AccountArtifact [artifact=" + this.artifact + ", preferences=" + this.preferences + "]";
    }
}

