/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.config.admin.internal;

import java.util.Hashtable;
import org.eclipse.osee.config.admin.internal.ConfigWriter;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ConfigParser {
    private static final String CONFIG_OBJECT = "config";

    public void process(ConfigWriter writer, String source) {
        if (Strings.isValid((String)source)) {
            try {
                JSONObject jsonObject = new JSONObject(source);
                JSONArray jsonArray = jsonObject.getJSONArray(CONFIG_OBJECT);
                int index = 0;
                while (index < jsonArray.length()) {
                    String[] names;
                    JSONObject object = jsonArray.getJSONObject(index);
                    String serviceId = null;
                    Hashtable<String, Object> properties = new Hashtable<String, Object>();
                    String[] stringArray = names = JSONObject.getNames((JSONObject)object);
                    int n = names.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String key = stringArray[n2];
                        String value = object.getString(key);
                        if (key.equalsIgnoreCase("service.pid")) {
                            serviceId = value;
                            properties.put("service.pid", serviceId);
                        } else {
                            properties.put(key, value);
                        }
                        ++n2;
                    }
                    if (Strings.isValid(serviceId)) {
                        writer.write(serviceId, properties);
                    }
                    ++index;
                }
            }
            catch (JSONException ex) {
                throw new OseeCoreException((Throwable)ex);
            }
        }
    }
}

