/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.account.rest.internal;

import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.osee.account.admin.Account;
import org.eclipse.osee.account.admin.Subscription;
import org.eclipse.osee.account.admin.SubscriptionAdmin;
import org.eclipse.osee.account.admin.SubscriptionGroup;
import org.eclipse.osee.account.rest.internal.AccountDataUtil;
import org.eclipse.osee.account.rest.model.AccountInfoData;
import org.eclipse.osee.account.rest.model.SubscriptionData;
import org.eclipse.osee.account.rest.model.SubscriptionGroupData;
import org.eclipse.osee.account.rest.model.SubscriptionGroupId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;

@Path(value="/subscriptions")
public class SubscriptionsResource {
    private final SubscriptionAdmin manager;

    public SubscriptionsResource(SubscriptionAdmin manager) {
        this.manager = manager;
    }

    @Path(value="/for-account/{account-id}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    public SubscriptionData[] getSubscriptions(@PathParam(value="account-id") Long accountId) {
        ArtifactId artId = ArtifactId.valueOf((long)accountId);
        ResultSet subscriptions = this.manager.getSubscriptionsByAccountId(artId);
        SubscriptionData[] toReturn = new SubscriptionData[subscriptions.size()];
        int index = 0;
        for (Subscription subscription : subscriptions) {
            toReturn[index++] = AccountDataUtil.asAccountSubscriptionData(subscription);
        }
        return toReturn;
    }

    @Path(value="/{subscription-uuid}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    public SubscriptionData getSubscriptionByEncoded(@PathParam(value="subscription-uuid") String encodedId) {
        Subscription accountSubscription = this.manager.getSubscriptionsByEncodedId(encodedId);
        return AccountDataUtil.asAccountSubscriptionData(accountSubscription);
    }

    @Path(value="/{subscription-uuid}/active")
    @PUT
    public Response setSubscriptionActive(@PathParam(value="subscription-uuid") String subscriptionUuid) {
        Subscription subcription = this.manager.getSubscriptionsByEncodedId(subscriptionUuid);
        boolean modified = this.manager.setSubscriptionActive(subcription, true);
        Response.ResponseBuilder builder = modified ? Response.ok() : Response.notModified();
        return builder.build();
    }

    @Path(value="/{subscription-uuid}/active")
    @DELETE
    public Response setSubscriptionInactive(@PathParam(value="subscription-uuid") String subscriptionUuid) {
        Subscription subcription = this.manager.getSubscriptionsByEncodedId(subscriptionUuid);
        boolean modified = this.manager.setSubscriptionActive(subcription, false);
        Response.ResponseBuilder builder = modified ? Response.ok() : Response.notModified();
        return builder.build();
    }

    @RolesAllowed(value={"authenticated"})
    @Path(value="/groups")
    @GET
    @Produces(value={"application/json", "application/xml"})
    public SubscriptionGroupData[] getSubscriptionGroups() {
        ResultSet groups = this.manager.getSubscriptionGroups();
        SubscriptionGroupData[] toReturn = new SubscriptionGroupData[groups.size()];
        int index = 0;
        for (SubscriptionGroup group : groups) {
            toReturn[index++] = AccountDataUtil.asSubscriptionGroupData(group);
        }
        return toReturn;
    }

    @RolesAllowed(value={"authenticated"})
    @Path(value="/groups/{group-id}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    public SubscriptionGroupData getSubscriptionGroup(@PathParam(value="group-id") Long groupId) {
        SubscriptionGroup subscription = this.manager.getSubscriptionGroupById(new SubscriptionGroupId(groupId));
        return AccountDataUtil.asSubscriptionGroupData(subscription);
    }

    @RolesAllowed(value={"authenticated"})
    @Path(value="/groups/{group-id}/members")
    @GET
    @Produces(value={"application/json", "application/xml"})
    public AccountInfoData[] getSubscriptionGroupMembers(@PathParam(value="group-id") Long groupId) {
        ResultSet accounts = this.manager.getSubscriptionMembersOfSubscriptionById(new SubscriptionGroupId(groupId));
        AccountInfoData[] toReturn = new AccountInfoData[accounts.size()];
        int index = 0;
        for (Account group : accounts) {
            toReturn[index++] = AccountDataUtil.asAccountData(group);
        }
        return toReturn;
    }

    @RolesAllowed(value={"authenticated"})
    @Path(value="/groups/{group-name}")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public SubscriptionGroupData createSubscriptionGroup(@PathParam(value="group-name") String groupName) {
        SubscriptionGroupId groupId = this.manager.createSubscriptionGroup(groupName);
        SubscriptionGroup subscription = this.manager.getSubscriptionGroupById(groupId);
        return AccountDataUtil.asSubscriptionGroupData(subscription);
    }

    @RolesAllowed(value={"authenticated"})
    @Path(value="/groups/{group-id}")
    @DELETE
    public Response deleteSubscriptionGroup(@PathParam(value="group-id") Long groupId) {
        boolean modified = this.manager.deleteSubscriptionById(new SubscriptionGroupId(groupId));
        Response.ResponseBuilder builder = modified ? Response.ok() : Response.notModified();
        return builder.build();
    }
}

