/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.account.rest.internal;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.account.admin.Account;
import org.eclipse.osee.account.admin.AccountAdmin;
import org.eclipse.osee.account.admin.CreateAccountRequest;
import org.eclipse.osee.account.admin.CreateAccountRequestBuilder;
import org.eclipse.osee.account.rest.internal.JaxRsAuthenticatorConstants;
import org.eclipse.osee.authentication.admin.AuthenticatedUser;
import org.eclipse.osee.authentication.admin.AuthenticationAdmin;
import org.eclipse.osee.authentication.admin.AuthenticationRequest;
import org.eclipse.osee.authentication.admin.AuthenticationRequestBuilder;
import org.eclipse.osee.authorization.admin.Authorization;
import org.eclipse.osee.authorization.admin.AuthorizationAdmin;
import org.eclipse.osee.authorization.admin.AuthorizationRequest;
import org.eclipse.osee.authorization.admin.AuthorizationRequestBuilder;
import org.eclipse.osee.authorization.admin.AuthorizationUser;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.jdk.core.type.BaseIdentity;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseePrincipal;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.jaxrs.server.security.JaxRsAuthenticator;

public class JaxRsAuthenticatorImpl
implements JaxRsAuthenticator {
    private AuthenticationAdmin authenticationAdmin;
    private AuthorizationAdmin authorizationAdmin;
    private AccountAdmin accountAdmin;
    private volatile boolean automaticAccountCreationAllowed = true;

    public void setAuthenticationAdmin(AuthenticationAdmin authenticationAdmin) {
        this.authenticationAdmin = authenticationAdmin;
    }

    public void setAccountAdmin(AccountAdmin accountAdmin) {
        this.accountAdmin = accountAdmin;
    }

    public void setAuthorizationAdmin(AuthorizationAdmin authorizationAdmin) {
        this.authorizationAdmin = authorizationAdmin;
    }

    public void start(Map<String, Object> props) {
        this.update(props);
    }

    public void stop() {
    }

    public void update(Map<String, Object> props) {
        this.automaticAccountCreationAllowed = JaxRsAuthenticatorImpl.getBoolean(props, JaxRsAuthenticatorConstants.JAXRS_AUTH__ALLOW_AUTOMATIC_ACCOUNT_CREATION, true);
    }

    public OseePrincipal getAnonymousPrincipal() {
        ResultSet result = this.accountAdmin.getAnonymousAccount();
        OseePrincipalImpl anonymous = null;
        Account account = (Account)result.getOneOrNull();
        if (account != null) {
            LinkedHashSet<String> roles = new LinkedHashSet<String>();
            roles.add("anonymous");
            Map<String, String> properties = Collections.emptyMap();
            anonymous = new OseePrincipalImpl(account.getUserName(), account, true, roles, properties);
        }
        return anonymous;
    }

    public OseePrincipal authenticate(String scheme, String username, String password) {
        AuthenticationRequest request = AuthenticationRequestBuilder.newBuilder().userName(username).password(password).build();
        AuthenticatedUser subject = this.authenticationAdmin.authenticate(request);
        Account account = this.resolveAccount(username, subject, this.automaticAccountCreationAllowed);
        LinkedHashSet<String> roles = new LinkedHashSet<String>();
        if (subject.isAuthenticated()) {
            roles.add("authenticated");
        } else {
            roles.add("anonymous");
        }
        for (String role : subject.getRoles()) {
            roles.add(role);
        }
        AuthorizationRequest authorizationRequest = AuthorizationRequestBuilder.newBuilder().secure(true).identifier(account.getId().longValue()).build();
        Authorization authorize = this.authorizationAdmin.authorize(authorizationRequest);
        AuthorizationUser authUser = (AuthorizationUser)authorize.getPrincipal();
        for (String role : authUser.getRoles()) {
            roles.add(role);
        }
        Map<String, String> properties = Collections.emptyMap();
        return new OseePrincipalImpl(username, account, subject.isAuthenticated(), roles, properties);
    }

    private Account resolveAccount(String login, AuthenticatedUser subject, boolean accountCreationAllowed) {
        ResultSet result = this.accountAdmin.getAccountByEmail(subject.getEmailAddress());
        Account account = (Account)result.getOneOrNull();
        if (account == null) {
            if (subject.isAuthenticated() && accountCreationAllowed) {
                CreateAccountRequest request = CreateAccountRequestBuilder.newBuilder().active(subject.isActive()).displayName(subject.getDisplayName()).email(subject.getEmailAddress()).userName(subject.getUserName()).build();
                ArtifactId accountId = this.accountAdmin.createAccount(request);
                account = (Account)this.accountAdmin.getAccountById(accountId).getExactlyOne();
            } else {
                throw new OseeCoreException("Account not found for [%s]", new Object[]{login});
            }
        }
        return account;
    }

    private static boolean getBoolean(Map<String, Object> props, String key, boolean defaultValue) {
        Object object;
        boolean toReturn = defaultValue;
        Object object2 = object = props != null ? props.get(key) : null;
        if (object != null) {
            if (object instanceof String) {
                toReturn = Boolean.parseBoolean((String)object);
            } else if (object instanceof Boolean) {
                toReturn = (Boolean)object;
            }
        }
        return toReturn;
    }

    private static final class OseePrincipalImpl
    extends BaseIdentity<Long>
    implements OseePrincipal {
        private final String login;
        private final Account data;
        private final boolean authenticated;
        private final Set<String> roles;
        private final Map<String, String> properties;

        public OseePrincipalImpl(String login, Account data, boolean authenticated, Set<String> roles, Map<String, String> properties) {
            super((Object)data.getId());
            this.login = login;
            this.data = data;
            this.authenticated = authenticated;
            this.roles = roles;
            this.properties = properties;
        }

        public String getDisplayName() {
            return this.data.getName();
        }

        public String getUserName() {
            return this.data.getUserName();
        }

        public String getEmailAddress() {
            return this.data.getEmail();
        }

        public boolean isActive() {
            return this.data.isActive();
        }

        public Set<String> getRoles() {
            return this.roles;
        }

        public boolean isAuthenticated() {
            return this.authenticated;
        }

        public String getName() {
            return this.getDisplayName();
        }

        public String getLogin() {
            return this.login;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public String getOseeGuid() {
            return (String)this.data.getGuid();
        }
    }
}

