/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.authentication.ldap.core;

import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osee.framework.authentication.ldap.core.Messages;
import org.eclipse.osee.framework.authentication.ldap.core.internal.LDAPConnector;
import org.eclipse.osee.framework.authentication.ldap.core.service.ILDAPService;
import org.eclipse.osee.framework.core.data.OseeCredential;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.server.AbstractAuthenticationProvider;
import org.osgi.framework.Bundle;

public class LDAPAuthenticationProvider
extends AbstractAuthenticationProvider {
    private final String extensionPointId = Messages.LDAPServiceExtensionPointID;
    private final String LDAP_SERVER_PREFIX = "ldap://";
    private LDAPConnector connector;

    public UserToken asOseeUserId(OseeCredential credential) {
        String userName = credential.getUserName();
        UserToken userToken = this.getUserTokenFromOseeDb(userName);
        return userToken != null ? userToken : this.createUserToken(true, userName, userName, "", true);
    }

    public boolean authenticate(OseeCredential credential) {
        boolean authLDAP = this.checkLDAPAuthenticated(credential);
        if (!authLDAP) {
            this.getLogger().error(Messages.LDAPAuthenticationFailed, new Object[0]);
        }
        return authLDAP;
    }

    public String getProtocol() {
        return Messages.LDAPAuthenticationProtocol;
    }

    protected boolean checkLDAPAuthenticated(OseeCredential credential) {
        boolean authenticate = false;
        ILDAPService ldapService = this.getLDAPServiceProviderExtension();
        if (ldapService == null) {
            return authenticate;
        }
        if (this.connector == null) {
            Hashtable<String, String> props = this.createLDAPContextProperies(ldapService);
            this.connector = new LDAPConnector(this.getLogger(), props, ldapService.getLDAPSearchBase());
        }
        if (this.connector == null) {
            return authenticate;
        }
        authenticate = this.connector.isLDAPUSer(credential.getUserName());
        return authenticate;
    }

    private Hashtable<String, String> createLDAPContextProperies(ILDAPService ldapService) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", ldapService.getLDAPUsername());
        env.put("java.naming.security.credentials", ldapService.getLDAPCrendentials());
        String ldapURL = String.valueOf("ldap://") + ldapService.getLDAPServerName() + ":" + ldapService.getLDAPPort();
        env.put("java.naming.provider.url", ldapURL);
        return env;
    }

    private ILDAPService getLDAPServiceProviderExtension() {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(this.extensionPointId);
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle;
                Object obj1;
                IConfigurationElement e = iConfigurationElementArray[n2];
                String className = e.getAttribute(Messages.LDAPServiceExtensionPointAttribute);
                String bundleName = e.getContributor().getName();
                if (className != null && bundleName != null && (obj1 = (bundle = Platform.getBundle((String)bundleName)).loadClass(className).newInstance()) != null && obj1 instanceof ILDAPService) {
                    return (ILDAPService)obj1;
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            this.getLogger().error((Throwable)ex, "Error reading LDAPServiceExtensionPoints", new Object[0]);
        }
        return null;
    }
}

