/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.dsl.integration.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.workdef.IAtsCompositeLayoutItem;
import org.eclipse.osee.ats.api.workdef.IAtsDecisionReviewDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsDecisionReviewOption;
import org.eclipse.osee.ats.api.workdef.IAtsLayoutItem;
import org.eclipse.osee.ats.api.workdef.IAtsPeerReviewDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsStateDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsWidgetDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinition;
import org.eclipse.osee.ats.api.workdef.WidgetOption;
import org.eclipse.osee.ats.api.workdef.model.RuleDefinitionOption;
import org.eclipse.osee.ats.dsl.atsDsl.AtsDsl;
import org.eclipse.osee.ats.dsl.atsDsl.AttrWidget;
import org.eclipse.osee.ats.dsl.atsDsl.BooleanDef;
import org.eclipse.osee.ats.dsl.atsDsl.Composite;
import org.eclipse.osee.ats.dsl.atsDsl.DecisionReviewDef;
import org.eclipse.osee.ats.dsl.atsDsl.DecisionReviewOpt;
import org.eclipse.osee.ats.dsl.atsDsl.DecisionReviewRef;
import org.eclipse.osee.ats.dsl.atsDsl.FollowupRef;
import org.eclipse.osee.ats.dsl.atsDsl.LayoutDef;
import org.eclipse.osee.ats.dsl.atsDsl.LayoutType;
import org.eclipse.osee.ats.dsl.atsDsl.PeerReviewDef;
import org.eclipse.osee.ats.dsl.atsDsl.ReviewBlockingType;
import org.eclipse.osee.ats.dsl.atsDsl.StateDef;
import org.eclipse.osee.ats.dsl.atsDsl.ToState;
import org.eclipse.osee.ats.dsl.atsDsl.UserByName;
import org.eclipse.osee.ats.dsl.atsDsl.UserByUserId;
import org.eclipse.osee.ats.dsl.atsDsl.WidgetDef;
import org.eclipse.osee.ats.dsl.atsDsl.WidgetRef;
import org.eclipse.osee.ats.dsl.atsDsl.WorkDef;
import org.eclipse.osee.ats.dsl.atsDsl.WorkflowEventType;
import org.eclipse.osee.ats.dsl.atsDsl.impl.AtsDslFactoryImpl;
import org.eclipse.osee.framework.core.util.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class ConvertWorkDefinitionToAtsDsl {
    private WorkDef dslWorkDef;
    private final XResultData resultData;
    private final Map<String, WidgetDef> idToDslWidgetDefMap = new HashMap<String, WidgetDef>(15);
    private final Map<String, StateDef> nameToDslStateDefMap = new HashMap<String, StateDef>(15);
    private final Map<String, DecisionReviewDef> nameToDslDecisionReviewDefMap = new HashMap<String, DecisionReviewDef>(0);
    private final Map<String, PeerReviewDef> nameToDslPeerReviewDefMap = new HashMap<String, PeerReviewDef>(0);

    public ConvertWorkDefinitionToAtsDsl(XResultData resultData) {
        this.resultData = resultData;
    }

    public AtsDsl convert(String definitionName, IAtsWorkDefinition workDef) {
        DecisionReviewRef dslRevRef;
        StateDef dslState;
        this.resultData.log("Converting " + workDef.getName() + " to " + definitionName);
        AtsDsl atsDsl = AtsDslFactoryImpl.init().createAtsDsl();
        this.dslWorkDef = AtsDslFactoryImpl.init().createWorkDef();
        this.dslWorkDef.setName(Strings.quote((String)definitionName));
        this.dslWorkDef.getId().add((Object)definitionName);
        for (IAtsStateDefinition stateDef : workDef.getStates()) {
            dslState = AtsDslFactoryImpl.init().createStateDef();
            this.dslWorkDef.getStates().add((Object)dslState);
            dslState.setName(Strings.quote((String)stateDef.getName()));
            this.nameToDslStateDefMap.put(stateDef.getName(), dslState);
            if (Strings.isValid((String)stateDef.getDescription())) {
                dslState.setDescription(stateDef.getDescription());
            }
            dslState.setOrdinal(stateDef.getOrdinal());
            dslState.setPageType(stateDef.getStateType().name());
            if (workDef.getStartState().getName().equals(stateDef.getName())) {
                this.dslWorkDef.setStartState(dslState);
            }
            List rules = stateDef.getRules();
            this.processWorkRulesForState(dslState, rules);
            this.processStateWidgets(stateDef, dslState);
        }
        for (IAtsStateDefinition stateDef : workDef.getStates()) {
            dslState = this.nameToDslStateDefMap.get(stateDef.getName());
            for (IAtsDecisionReviewDefinition revDef : stateDef.getDecisionReviews()) {
                DecisionReviewDef dslDecisionRevDef = this.nameToDslDecisionReviewDefMap.get(revDef.getName());
                if (dslDecisionRevDef == null) {
                    dslDecisionRevDef = this.createDslDecisionReviewDef(revDef);
                    this.dslWorkDef.getDecisionReviewDefs().add((Object)dslDecisionRevDef);
                    this.nameToDslDecisionReviewDefMap.put(revDef.getName(), dslDecisionRevDef);
                }
                dslRevRef = AtsDslFactoryImpl.init().createDecisionReviewRef();
                dslRevRef.setDecisionReview(dslDecisionRevDef);
                dslState.getDecisionReviews().add((Object)dslRevRef);
            }
        }
        for (IAtsStateDefinition stateDef : workDef.getStates()) {
            dslState = this.nameToDslStateDefMap.get(stateDef.getName());
            for (IAtsDecisionReviewDefinition revDef : stateDef.getPeerReviews()) {
                PeerReviewDef dslPeerRevDef = this.nameToDslPeerReviewDefMap.get(revDef.getName());
                if (dslPeerRevDef == null) {
                    dslPeerRevDef = this.createDslPeerReviewDef((IAtsPeerReviewDefinition)revDef);
                    this.dslWorkDef.getPeerReviewDefs().add((Object)dslPeerRevDef);
                    this.nameToDslPeerReviewDefMap.put(revDef.getName(), dslPeerRevDef);
                }
                dslRevRef = AtsDslFactoryImpl.init().createPeerReviewRef();
                dslRevRef.setPeerReview(dslPeerRevDef);
                dslState.getPeerReviews().add((Object)dslRevRef);
            }
        }
        for (IAtsStateDefinition stateDef : workDef.getStates()) {
            HashSet<String> toStateNames = new HashSet<String>();
            StateDef dslStateDef = this.nameToDslStateDefMap.get(stateDef.getName());
            for (IAtsStateDefinition toStateDef : stateDef.getToStates()) {
                if (toStateDef.getName().equals(stateDef.getName()) || toStateNames.contains(toStateDef.getName())) continue;
                toStateNames.add(toStateDef.getName());
                ToState dslToState = AtsDslFactoryImpl.init().createToState();
                dslStateDef.getTransitionStates().add((Object)dslToState);
                StateDef dslToStateDef = this.nameToDslStateDefMap.get(toStateDef.getName());
                dslToState.setState(dslToStateDef);
                if (stateDef.getDefaultToState() != null && stateDef.getDefaultToState().getName().equals(toStateDef.getName())) {
                    dslToState.getOptions().add((Object)"AsDefault");
                }
                if (!stateDef.getOverrideAttributeValidationStates().contains(toStateDef)) continue;
                dslToState.getOptions().add((Object)"OverrideAttributeValidation");
            }
        }
        this.resultData.log("Complete");
        atsDsl.getWorkDef().add((Object)this.dslWorkDef);
        return atsDsl;
    }

    protected void processStateWidgets(IAtsStateDefinition stateDef, StateDef dslState) {
        if (!stateDef.getLayoutItems().isEmpty()) {
            LayoutDef layout = AtsDslFactoryImpl.init().createLayoutDef();
            dslState.setLayout((LayoutType)layout);
            this.processStateItems(stateDef.getLayoutItems(), layout, null);
        }
    }

    protected void processWorkRulesForState(StateDef dslState, List<String> rules) {
        for (String ruleName : rules) {
            ruleName = ruleName.replaceAll("^ats", "");
            try {
                RuleDefinitionOption.valueOf((String)ruleName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ruleName = Strings.quote((String)ruleName);
            }
            dslState.getRules().add((Object)ruleName);
        }
    }

    protected DecisionReviewDef createDslDecisionReviewDef(IAtsDecisionReviewDefinition revDef) {
        DecisionReviewDef dslRevDef = AtsDslFactoryImpl.init().createDecisionReviewDef();
        dslRevDef.setName(revDef.getName());
        dslRevDef.setBlockingType(ReviewBlockingType.getByName((String)revDef.getBlockingType().name()));
        dslRevDef.setDescription(revDef.getDescription());
        dslRevDef.setStateEvent(WorkflowEventType.getByName((String)revDef.getStateEventType().name()));
        StateDef dslStateDef = this.nameToDslStateDefMap.get(revDef.getRelatedToState());
        dslRevDef.setRelatedToState(dslStateDef);
        dslRevDef.setTitle(revDef.getReviewTitle());
        for (String userId : revDef.getAssignees()) {
            UserByUserId dslUserId = AtsDslFactoryImpl.init().createUserByUserId();
            dslUserId.setUserId(userId);
            dslRevDef.getAssigneeRefs().add((Object)dslUserId);
        }
        if (revDef.isAutoTransitionToDecision()) {
            dslRevDef.setAutoTransitionToDecision(BooleanDef.TRUE);
        } else {
            dslRevDef.setAutoTransitionToDecision(BooleanDef.FALSE);
        }
        for (IAtsDecisionReviewOption revOpt : revDef.getOptions()) {
            DecisionReviewOpt dslRevOpt = AtsDslFactoryImpl.init().createDecisionReviewOpt();
            dslRevDef.getOptions().add((Object)dslRevOpt);
            dslRevOpt.setName(revOpt.getName());
            if (!revOpt.isFollowupRequired()) continue;
            FollowupRef dslFollowupRef = AtsDslFactoryImpl.init().createFollowupRef();
            for (String userId : revOpt.getUserIds()) {
                UserByUserId assigneeById = AtsDslFactoryImpl.init().createUserByUserId();
                assigneeById.setUserId(userId);
                dslFollowupRef.getAssigneeRefs().add((Object)assigneeById);
            }
            for (String userName : revOpt.getUserNames()) {
                UserByName assigneeByName = AtsDslFactoryImpl.init().createUserByName();
                assigneeByName.setUserName(userName);
                dslFollowupRef.getAssigneeRefs().add((Object)assigneeByName);
            }
            dslRevOpt.setFollowup(dslFollowupRef);
        }
        return dslRevDef;
    }

    protected PeerReviewDef createDslPeerReviewDef(IAtsPeerReviewDefinition revDef) {
        PeerReviewDef peerRevDef = AtsDslFactoryImpl.init().createPeerReviewDef();
        peerRevDef.setName(revDef.getName());
        peerRevDef.setBlockingType(ReviewBlockingType.getByName((String)revDef.getBlockingType().name()));
        peerRevDef.setDescription(revDef.getDescription());
        if (Strings.isValid((String)revDef.getLocation())) {
            peerRevDef.setLocation(revDef.getLocation());
        }
        if (Strings.isValid((String)revDef.getReviewTitle())) {
            peerRevDef.setTitle(revDef.getReviewTitle());
        }
        for (String userId : revDef.getAssignees()) {
            UserByUserId dslUserId = AtsDslFactoryImpl.init().createUserByUserId();
            dslUserId.setUserId(userId);
            peerRevDef.getAssigneeRefs().add((Object)dslUserId);
        }
        peerRevDef.setStateEvent(WorkflowEventType.getByName((String)revDef.getStateEventType().name()));
        StateDef dslStateDef = this.nameToDslStateDefMap.get(revDef.getRelatedToState());
        peerRevDef.setRelatedToState(dslStateDef);
        return peerRevDef;
    }

    private void processStateItems(List<IAtsLayoutItem> stateItems, LayoutDef layout, Composite dslComposite) {
        for (IAtsLayoutItem stateItem : stateItems) {
            this.processStateItem(layout, dslComposite, stateItem);
        }
    }

    protected void processStateItem(LayoutDef layout, Composite dslComposite, IAtsLayoutItem stateItem) {
        if (stateItem instanceof IAtsWidgetDefinition) {
            IAtsWidgetDefinition widgetDef = (IAtsWidgetDefinition)stateItem;
            this.processWidgetDefinition(layout, dslComposite, widgetDef);
        } else if (stateItem instanceof IAtsCompositeLayoutItem) {
            IAtsCompositeLayoutItem composite = (IAtsCompositeLayoutItem)stateItem;
            this.processCompositeStateItem(layout, dslComposite, composite);
        } else {
            this.resultData.error("Unexpected stateItem => " + stateItem.getName());
        }
    }

    protected void processCompositeStateItem(LayoutDef layout, Composite dslComposite, IAtsCompositeLayoutItem composite) {
        Composite newDslComposite = AtsDslFactoryImpl.init().createComposite();
        newDslComposite.setNumColumns(composite.getNumColumns());
        if (dslComposite != null) {
            dslComposite.getLayoutItems().add((Object)newDslComposite);
        } else {
            layout.getLayoutItems().add((Object)newDslComposite);
        }
        this.processStateItems(composite.getaLayoutItems(), layout, newDslComposite);
    }

    protected void processWidgetDefinition(LayoutDef layout, Composite dslComposite, IAtsWidgetDefinition widgetDef) {
        AttrWidget attrWidget = this.getAttrWidget(widgetDef);
        if (attrWidget != null) {
            if (dslComposite != null) {
                dslComposite.getLayoutItems().add((Object)attrWidget);
            } else {
                layout.getLayoutItems().add((Object)attrWidget);
            }
        } else {
            WidgetDef dslWidgetDef = this.getOrCreateWidget(widgetDef);
            WidgetRef dslWidgetRef = AtsDslFactoryImpl.init().createWidgetRef();
            dslWidgetRef.setWidget(dslWidgetDef);
            if (dslComposite != null) {
                dslComposite.getLayoutItems().add((Object)dslWidgetRef);
            } else {
                layout.getLayoutItems().add((Object)dslWidgetRef);
            }
        }
    }

    private AttrWidget getAttrWidget(IAtsWidgetDefinition widgetDef) {
        List<String> names = Arrays.asList("Change Type", "Priority", "Need By", "Estimated Hours", "Work Package", "Validation Required", "Estimated Completion Date", "Legacy PCR Id", "Related To State", "LOC Changed", "LOC Reviewed", "Pages Changed", "Pages Reviewed", "Goal Order Vote", "Reference Number", "Submitted to Data Management", "Submitted to Customer", "Doc Number", "Revision Letter", "CTE SW Release", "Dup CPCR No");
        if (names.contains(widgetDef.getName())) {
            AttrWidget attrWidget = AtsDslFactoryImpl.init().createAttrWidget();
            attrWidget.setAttributeName(widgetDef.getAtrributeName());
            return attrWidget;
        }
        return null;
    }

    protected WidgetDef getOrCreateWidget(IAtsWidgetDefinition widgetDef) {
        WidgetDef dslWidget = null;
        if (this.idToDslWidgetDefMap.containsKey(widgetDef.getName())) {
            dslWidget = this.idToDslWidgetDefMap.get(widgetDef.getName());
        } else {
            dslWidget = AtsDslFactoryImpl.init().createWidgetDef();
            dslWidget.setName(Strings.quote((String)widgetDef.getName()));
            dslWidget.setDefaultValue(widgetDef.getDefaultValue());
            dslWidget.setDescription(widgetDef.getDescription());
            for (WidgetOption option : widgetDef.getOptions().getXOptions()) {
                dslWidget.getOption().add((Object)option.name());
            }
            dslWidget.setAttributeName(widgetDef.getAtrributeName());
            dslWidget.setHeight(widgetDef.getHeight());
            dslWidget.setXWidgetName(widgetDef.getXWidgetName());
            this.idToDslWidgetDefMap.put(widgetDef.getName(), dslWidget);
        }
        if (this.dslWorkDef != null) {
            this.dslWorkDef.getWidgetDefs().add((Object)dslWidget);
        }
        return dslWidget;
    }
}

