/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.dsl.integration.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osee.ats.api.user.IAtsUserService;
import org.eclipse.osee.ats.api.workdef.IAtsDecisionReviewDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsLayoutItem;
import org.eclipse.osee.ats.api.workdef.IAtsPeerReviewDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsStateDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsWidgetDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinition;
import org.eclipse.osee.ats.api.workdef.IAttributeResolver;
import org.eclipse.osee.ats.api.workdef.StateColor;
import org.eclipse.osee.ats.api.workdef.StateEventType;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workdef.WidgetOption;
import org.eclipse.osee.ats.api.workdef.model.CompositeLayoutItem;
import org.eclipse.osee.ats.api.workdef.model.DecisionReviewDefinition;
import org.eclipse.osee.ats.api.workdef.model.DecisionReviewOption;
import org.eclipse.osee.ats.api.workdef.model.PeerReviewDefinition;
import org.eclipse.osee.ats.api.workdef.model.ReviewBlockType;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workdef.model.WidgetDefinition;
import org.eclipse.osee.ats.api.workdef.model.WorkDefinition;
import org.eclipse.osee.ats.dsl.BooleanDefUtil;
import org.eclipse.osee.ats.dsl.UserRefUtil;
import org.eclipse.osee.ats.dsl.atsDsl.AtsDsl;
import org.eclipse.osee.ats.dsl.atsDsl.AttrWidget;
import org.eclipse.osee.ats.dsl.atsDsl.BooleanDef;
import org.eclipse.osee.ats.dsl.atsDsl.Composite;
import org.eclipse.osee.ats.dsl.atsDsl.DecisionReviewDef;
import org.eclipse.osee.ats.dsl.atsDsl.DecisionReviewOpt;
import org.eclipse.osee.ats.dsl.atsDsl.DecisionReviewRef;
import org.eclipse.osee.ats.dsl.atsDsl.FollowupRef;
import org.eclipse.osee.ats.dsl.atsDsl.LayoutCopy;
import org.eclipse.osee.ats.dsl.atsDsl.LayoutDef;
import org.eclipse.osee.ats.dsl.atsDsl.LayoutItem;
import org.eclipse.osee.ats.dsl.atsDsl.LayoutType;
import org.eclipse.osee.ats.dsl.atsDsl.PeerReviewDef;
import org.eclipse.osee.ats.dsl.atsDsl.PeerReviewRef;
import org.eclipse.osee.ats.dsl.atsDsl.StateDef;
import org.eclipse.osee.ats.dsl.atsDsl.ToState;
import org.eclipse.osee.ats.dsl.atsDsl.UserByName;
import org.eclipse.osee.ats.dsl.atsDsl.UserByUserId;
import org.eclipse.osee.ats.dsl.atsDsl.UserRef;
import org.eclipse.osee.ats.dsl.atsDsl.WidgetDef;
import org.eclipse.osee.ats.dsl.atsDsl.WidgetRef;
import org.eclipse.osee.ats.dsl.atsDsl.WorkDef;
import org.eclipse.osee.framework.core.util.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class ConvertAtsDslToWorkDefinition {
    private final String name;
    private final AtsDsl atsDsl;
    private final XResultData resultData;
    private final IAttributeResolver attrResolver;
    private final IAtsUserService userService;

    public ConvertAtsDslToWorkDefinition(String name, AtsDsl atsDsl, XResultData resultData, IAttributeResolver attrResolver, IAtsUserService userService) {
        this.name = name;
        this.atsDsl = atsDsl;
        this.resultData = resultData;
        this.attrResolver = attrResolver;
        this.userService = userService;
    }

    public Collection<IAtsWorkDefinition> convert() {
        ArrayList<IAtsWorkDefinition> workDefs = new ArrayList<IAtsWorkDefinition>();
        for (WorkDef dslWorkDef : this.atsDsl.getWorkDef()) {
            DecisionReviewDefinition revDef;
            DecisionReviewDef dslRevDef;
            StateDefinition stateDef;
            WorkDefinition workDef = new WorkDefinition(Strings.unquote((String)dslWorkDef.getName()));
            workDef.setId((String)dslWorkDef.getId().iterator().next());
            List<IAtsWidgetDefinition> widgetDefs = this.retrieveWigetDefs(this.atsDsl, dslWorkDef, this.name);
            HashMap<StateDefinition, String> copyLayoutFromMap = new HashMap<StateDefinition, String>();
            for (StateDef dslState : dslWorkDef.getStates()) {
                String stateName = Strings.unquote((String)dslState.getName());
                StateDefinition stateDef2 = new StateDefinition(stateName);
                workDef.addState((IAtsStateDefinition)stateDef2);
                stateDef2.setWorkDefinition((IAtsWorkDefinition)workDef);
                stateDef2.setOrdinal(dslState.getOrdinal());
                StateType stateType = StateType.Working;
                try {
                    stateType = StateType.valueOf((String)dslState.getPageType());
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                stateDef2.setStateType(stateType);
                stateDef2.setStateWeight(dslState.getPercentWeight());
                stateDef2.setRecommendedPercentComplete(dslState.getRecommendedPercentComplete());
                StateColor color = StateColor.BLACK;
                try {
                    if (Strings.isValid((String)dslState.getColor())) {
                        color = StateColor.valueOf((String)dslState.getColor());
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                stateDef2.setColor(color);
                LayoutType layout = dslState.getLayout();
                if (layout instanceof LayoutDef) {
                    this.processLayoutItems(this.name, widgetDefs, stateDef2.getLayoutItems(), (EList<LayoutItem>)((LayoutDef)layout).getLayoutItems());
                } else if (layout instanceof LayoutCopy) {
                    copyLayoutFromMap.put(stateDef2, Strings.unquote((String)((LayoutCopy)layout).getState().getName()));
                }
                for (String ruleName : dslState.getRules()) {
                    stateDef2.addRule(Strings.unquote((String)ruleName));
                }
            }
            for (Map.Entry entry : copyLayoutFromMap.entrySet()) {
                IAtsStateDefinition fromStateDef = workDef.getStateByName((String)entry.getValue());
                IAtsStateDefinition toStateDef = (IAtsStateDefinition)entry.getKey();
                for (IAtsLayoutItem item : fromStateDef.getLayoutItems()) {
                    toStateDef.getLayoutItems().add(item);
                }
            }
            for (StateDef dslState : dslWorkDef.getStates()) {
                stateDef = (StateDefinition)workDef.getStateByName(Strings.unquote((String)dslState.getName()));
                for (ToState dslToState : dslState.getTransitionStates()) {
                    IAtsStateDefinition toStateDef = workDef.getStateByName(Strings.unquote((String)dslToState.getState().getName()));
                    stateDef.getToStates().add(toStateDef);
                    for (String dslTransOption : dslToState.getOptions()) {
                        if ("AsDefault".equals(dslTransOption)) {
                            stateDef.setDefaultToState(toStateDef);
                        }
                        if (!"OverrideAttributeValidation".equals(dslTransOption)) continue;
                        stateDef.getOverrideAttributeValidationStates().add(toStateDef);
                    }
                }
            }
            for (StateDef dslState : dslWorkDef.getStates()) {
                stateDef = workDef.getStateByName(Strings.unquote((String)dslState.getName()));
                for (DecisionReviewRef dslRevRef : dslState.getDecisionReviews()) {
                    dslRevDef = dslRevRef.getDecisionReview();
                    revDef = (DecisionReviewDefinition)this.convertDslDecisionReview(dslRevDef);
                    if (!Strings.isValid((String)revDef.getRelatedToState())) {
                        revDef.setRelatedToState(stateDef.getName());
                    }
                    stateDef.getDecisionReviews().add(revDef);
                }
            }
            for (StateDef dslState : dslWorkDef.getStates()) {
                stateDef = workDef.getStateByName(Strings.unquote((String)dslState.getName()));
                for (PeerReviewRef peerRevRef : dslState.getPeerReviews()) {
                    dslRevDef = peerRevRef.getPeerReview();
                    revDef = (PeerReviewDefinition)this.convertDslPeerReview((PeerReviewDef)dslRevDef);
                    if (!Strings.isValid((String)revDef.getRelatedToState())) {
                        revDef.setRelatedToState(stateDef.getName());
                    }
                    stateDef.getPeerReviews().add(revDef);
                }
            }
            workDef.setStartState(workDef.getStateByName(Strings.unquote((String)dslWorkDef.getStartState().getName())));
            workDef.setName(this.name);
            workDef.setId(this.name);
            workDefs.add((IAtsWorkDefinition)workDef);
        }
        return workDefs;
    }

    private IAtsDecisionReviewDefinition convertDslDecisionReview(DecisionReviewDef dslRevDef) {
        DecisionReviewDefinition revDef = new DecisionReviewDefinition(dslRevDef.getName());
        revDef.setReviewTitle(dslRevDef.getTitle());
        revDef.setDescription(dslRevDef.getDescription());
        String dslBlockType = dslRevDef.getBlockingType().getName();
        ReviewBlockType blockType = ReviewBlockType.None;
        try {
            blockType = ReviewBlockType.valueOf((String)dslBlockType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(String.format("Unknown ReviewBlockType [%s]; Defaulting to None", dslBlockType));
        }
        revDef.setBlockingType(blockType);
        String dslEventType = dslRevDef.getStateEvent().getName();
        StateEventType eventType = StateEventType.None;
        try {
            eventType = StateEventType.valueOf((String)dslEventType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(String.format("Unknown StateEventType [%s]; Defaulting to None", dslEventType));
        }
        revDef.setStateEventType(eventType);
        revDef.setAutoTransitionToDecision(BooleanDefUtil.get((BooleanDef)dslRevDef.getAutoTransitionToDecision(), (boolean)false));
        for (DecisionReviewOpt dslOpt : dslRevDef.getOptions()) {
            DecisionReviewOption revOpt = new DecisionReviewOption(Strings.unquote((String)dslOpt.getName()));
            FollowupRef followupRef = dslOpt.getFollowup();
            if (followupRef == null) {
                revOpt.setFollowupRequired(false);
            } else {
                revOpt.setFollowupRequired(true);
                revOpt.getUserIds().addAll(UserRefUtil.getUserIds((EList)followupRef.getAssigneeRefs()));
                revOpt.getUserNames().addAll(UserRefUtil.getUserNames((EList)followupRef.getAssigneeRefs()));
            }
            revDef.getOptions().add(revOpt);
        }
        Collection<String> userIds = this.getAssigneesFromUserRefs((EList<UserRef>)dslRevDef.getAssigneeRefs());
        revDef.getAssignees().addAll(userIds);
        return revDef;
    }

    private void processLayoutItems(String SHEET_NAME, List<IAtsWidgetDefinition> widgetDefs, List<IAtsLayoutItem> stateItems, EList<LayoutItem> layoutItems) {
        for (LayoutItem layoutItem : layoutItems) {
            if (layoutItem instanceof WidgetDef) {
                IAtsWidgetDefinition widgetDef = this.convertDslWidgetDef((WidgetDef)layoutItem, SHEET_NAME);
                stateItems.add((IAtsLayoutItem)widgetDef);
                continue;
            }
            if (layoutItem instanceof WidgetRef) {
                String widgetName = Strings.unquote((String)((WidgetRef)layoutItem).getWidget().getName());
                boolean found = false;
                for (IAtsWidgetDefinition wd : widgetDefs) {
                    if (!wd.getName().equals(widgetName)) continue;
                    stateItems.add((IAtsLayoutItem)wd);
                    found = true;
                }
                if (found) continue;
                this.resultData.errorf("Could not find WidgetRef [%s] in WidgetDefs", new Object[]{widgetName});
                continue;
            }
            if (layoutItem instanceof AttrWidget) {
                AttrWidget attrWidget = (AttrWidget)layoutItem;
                String attributeName = Strings.unquote((String)attrWidget.getAttributeName());
                try {
                    if (!this.attrResolver.isAttributeNamed(attributeName)) {
                        this.resultData.errorf("Invalid attribute name [%s] in WorkDefinition [%s] (1)", new Object[]{attributeName, SHEET_NAME});
                        continue;
                    }
                    WidgetDefinition widgetDef = new WidgetDefinition(this.attrResolver.getUnqualifiedName(attributeName));
                    widgetDef.setAttributeName(attributeName);
                    this.attrResolver.setXWidgetNameBasedOnAttributeName(attributeName, (IAtsWidgetDefinition)widgetDef);
                    this.extractDslWidgetDefOptions((EList<String>)attrWidget.getOption(), SHEET_NAME, (IAtsWidgetDefinition)widgetDef);
                    stateItems.add((IAtsLayoutItem)widgetDef);
                }
                catch (Exception exception) {
                    this.resultData.errorf("Error resolving attribute [%s] to WorkDefinition in [%s]", new Object[]{attributeName, SHEET_NAME});
                }
                continue;
            }
            if (!(layoutItem instanceof Composite)) continue;
            Composite composite = (Composite)layoutItem;
            CompositeLayoutItem compStateItem = new CompositeLayoutItem(composite.getNumColumns());
            if (!composite.getLayoutItems().isEmpty()) {
                this.processLayoutItems(SHEET_NAME, widgetDefs, compStateItem.getaLayoutItems(), (EList<LayoutItem>)composite.getLayoutItems());
            }
            stateItems.add((IAtsLayoutItem)compStateItem);
        }
    }

    private IAtsPeerReviewDefinition convertDslPeerReview(PeerReviewDef dslRevDef) {
        PeerReviewDefinition revDef = new PeerReviewDefinition(Strings.unquote((String)dslRevDef.getName()));
        revDef.setReviewTitle(Strings.unquote((String)dslRevDef.getTitle()));
        revDef.setDescription(Strings.unquote((String)dslRevDef.getDescription()));
        revDef.setLocation(Strings.unquote((String)dslRevDef.getLocation()));
        String dslBlockType = dslRevDef.getBlockingType().getName();
        ReviewBlockType blockType = ReviewBlockType.None;
        try {
            blockType = ReviewBlockType.valueOf((String)dslBlockType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.resultData.warningf("Unknown ReviewBlockType [%s]; Defaulting to None", new Object[]{dslBlockType});
        }
        revDef.setBlockingType(blockType);
        String dslEventType = Strings.unquote((String)dslRevDef.getStateEvent().getName());
        StateEventType eventType = StateEventType.None;
        try {
            eventType = StateEventType.valueOf((String)dslEventType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.resultData.warningf("Unknown StateEventType [%s]; Defaulting to None", new Object[]{dslEventType});
        }
        revDef.setStateEventType(eventType);
        Collection<String> userIds = this.getAssigneesFromUserRefs((EList<UserRef>)dslRevDef.getAssigneeRefs());
        revDef.getAssignees().addAll(userIds);
        return revDef;
    }

    private Collection<String> getAssigneesFromUserRefs(EList<UserRef> UserRefs) {
        HashSet<String> userIds = new HashSet<String>();
        for (UserRef UserRef2 : UserRefs) {
            if (UserRef2 instanceof UserByName) {
                UserByName byName = (UserByName)UserRef2;
                String name = Strings.unquote((String)byName.getUserName());
                if (!Strings.isValid((String)name)) {
                    this.resultData.warningf("Unhandled UserByName name [%s]", new Object[]{name});
                    continue;
                }
                try {
                    if (this.userService.isUserNameValid(name)) {
                        userIds.add(this.userService.getUserByName(name).getUserId());
                        continue;
                    }
                    this.resultData.warningf("No user by name [%s]", new Object[]{name});
                }
                catch (OseeCoreException oseeCoreException) {
                    this.resultData.errorf("Exception user by name [%s]", new Object[]{name});
                }
                continue;
            }
            if (UserRef2 instanceof UserByUserId) {
                UserByUserId byUserId = (UserByUserId)UserRef2;
                String userId = Strings.unquote((String)byUserId.getUserId());
                if (!Strings.isValid((String)userId)) {
                    this.resultData.warningf("Unhandled UserByUserId id [%s]", new Object[]{userId});
                    continue;
                }
                try {
                    if (this.userService.isUserIdValid(userId)) {
                        userIds.add(userId);
                        continue;
                    }
                    this.resultData.warningf("No user by id [%s]", new Object[]{userId});
                }
                catch (OseeCoreException oseeCoreException) {
                    this.resultData.errorf("Exception user by id [%s]", new Object[]{this.name});
                }
                continue;
            }
            this.resultData.warningf("Unhandled UserRef type [%s]", new Object[]{UserRef2});
        }
        return userIds;
    }

    private List<IAtsWidgetDefinition> retrieveWigetDefs(AtsDsl atsDsl, WorkDef dslWorkDef, String SHEET_NAME) {
        ArrayList<IAtsWidgetDefinition> widgetDefs = new ArrayList<IAtsWidgetDefinition>();
        for (WidgetDef dslWidgetDef : dslWorkDef.getWidgetDefs()) {
            IAtsWidgetDefinition widgetDef = this.convertDslWidgetDef(dslWidgetDef, SHEET_NAME);
            widgetDefs.add(widgetDef);
        }
        return widgetDefs;
    }

    private IAtsWidgetDefinition convertDslWidgetDef(WidgetDef dslWidgetDef, String SHEET_NAME) {
        WidgetDefinition widgetDef;
        block12: {
            widgetDef = new WidgetDefinition(Strings.unquote((String)dslWidgetDef.getName()));
            String attributeName = Strings.unquote((String)dslWidgetDef.getAttributeName());
            widgetDef.setAttributeName(attributeName);
            try {
                if (Strings.isValid((String)dslWidgetDef.getDescription())) {
                    widgetDef.setDescription(dslWidgetDef.getDescription());
                } else if (Strings.isValid((String)attributeName) && this.attrResolver.isAttributeNamed(attributeName) && Strings.isValid((String)this.attrResolver.getDescription(attributeName))) {
                    widgetDef.setDescription(this.attrResolver.getDescription(attributeName));
                }
            }
            catch (Exception ex) {
                this.resultData.errorf("Exception [%s] in WorkDefinition [%s]", new Object[]{ex.getLocalizedMessage(), SHEET_NAME});
            }
            String xWidgetName = Strings.unquote((String)dslWidgetDef.getXWidgetName());
            if (Strings.isValid((String)xWidgetName)) {
                widgetDef.setXWidgetName(xWidgetName);
            } else if (Strings.isValid((String)attributeName)) {
                try {
                    if (!this.attrResolver.isAttributeNamed(attributeName)) {
                        this.resultData.errorf("Invalid attribute name [%s] in WorkDefinition [%s] (2)", new Object[]{attributeName, SHEET_NAME});
                        break block12;
                    }
                    this.attrResolver.setXWidgetNameBasedOnAttributeName(attributeName, (IAtsWidgetDefinition)widgetDef);
                }
                catch (Exception exception) {
                    this.resultData.errorf("Error resolving attribute name [%s] in WorkDefinition [%s]", new Object[]{attributeName, SHEET_NAME});
                }
            } else {
                this.resultData.errorf("Invalid attribute name [%s] in WorkDefinition [%s] (3)", new Object[]{attributeName, SHEET_NAME});
            }
        }
        this.processMinMaxConstraints((IAtsWidgetDefinition)widgetDef, dslWidgetDef.getMinConstraint(), dslWidgetDef.getMaxConstraint());
        widgetDef.setHeight(dslWidgetDef.getHeight());
        widgetDef.setDefaultValue(dslWidgetDef.getDefaultValue());
        this.extractDslWidgetDefOptions((EList<String>)dslWidgetDef.getOption(), SHEET_NAME, (IAtsWidgetDefinition)widgetDef);
        return widgetDef;
    }

    private void processMinMaxConstraints(IAtsWidgetDefinition widgetDef, String minConstraint, String maxConstraint) {
        if (!Strings.isValid((String)minConstraint) && !Strings.isValid((String)maxConstraint)) {
            return;
        }
        String name = widgetDef.getXWidgetName();
        if ((name.contains("Float") || name.contains("Integer") || name.contains("List")) && minConstraint.matches("[-+]?\\d*\\.?\\d*") && maxConstraint.matches("[-+]?\\d*\\.?\\d*")) {
            widgetDef.setConstraint(Double.parseDouble(minConstraint), Double.parseDouble(minConstraint));
        }
    }

    private void extractDslWidgetDefOptions(EList<String> options, String SHEET_NAME, IAtsWidgetDefinition widgetDef) {
        for (String value : options) {
            WidgetOption option = null;
            try {
                option = WidgetOption.valueOf((String)value);
                widgetDef.getOptions().add(option);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.resultData.warningf("Unexpected value [%s] in WorkDefinition [%s]", new Object[]{value, SHEET_NAME});
            }
        }
    }
}

