/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.dsl.integration.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.user.IAtsUserService;
import org.eclipse.osee.ats.api.workdef.CreateTaskRuleDefinition;
import org.eclipse.osee.ats.api.workdef.DecisionReviewRuleDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsRuleDefinition;
import org.eclipse.osee.ats.api.workdef.RuleEventType;
import org.eclipse.osee.ats.api.workdef.RuleLocations;
import org.eclipse.osee.ats.api.workdef.model.PeerReviewRuleDefinition;
import org.eclipse.osee.ats.api.workdef.model.ReviewBlockType;
import org.eclipse.osee.ats.api.workdef.model.RuleDefinition;
import org.eclipse.osee.ats.dsl.atsDsl.AtsDsl;
import org.eclipse.osee.ats.dsl.atsDsl.BooleanDef;
import org.eclipse.osee.ats.dsl.atsDsl.CreateDecisionReviewRule;
import org.eclipse.osee.ats.dsl.atsDsl.CreatePeerReviewRule;
import org.eclipse.osee.ats.dsl.atsDsl.CreateTaskRule;
import org.eclipse.osee.ats.dsl.atsDsl.OnEventType;
import org.eclipse.osee.ats.dsl.atsDsl.Rule;
import org.eclipse.osee.ats.dsl.atsDsl.RuleLocation;
import org.eclipse.osee.ats.dsl.atsDsl.UserDef;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;

public class ConvertAtsDslToRuleDefinition {
    private final AtsDsl atsDsl;
    private final List<IAtsRuleDefinition> ruleList;
    private final IAtsUserService userService;

    public ConvertAtsDslToRuleDefinition(AtsDsl atsDsl, List<IAtsRuleDefinition> ruleList, IAtsUserService userService) {
        this.atsDsl = atsDsl;
        this.ruleList = ruleList;
        this.userService = userService;
    }

    public List<IAtsRuleDefinition> convert() {
        for (Rule rule : this.atsDsl.getRule()) {
            CreateTaskRuleDefinition newRule;
            if (rule instanceof CreateTaskRule) {
                newRule = new CreateTaskRuleDefinition();
                this.convertCreateTaskRule(newRule, (CreateTaskRule)rule);
            } else if (rule instanceof PeerReviewRuleDefinition) {
                newRule = new PeerReviewRuleDefinition();
                this.convertPeerReviewRule((PeerReviewRuleDefinition)newRule, (CreatePeerReviewRule)rule);
            } else if (rule instanceof DecisionReviewRuleDefinition) {
                newRule = new DecisionReviewRuleDefinition();
                this.convertDecisionReviewRule((DecisionReviewRuleDefinition)newRule, (CreateDecisionReviewRule)rule);
            } else {
                newRule = new RuleDefinition();
            }
            this.setRuleDefinitionValues((RuleDefinition)newRule, rule);
            this.ruleList.add((IAtsRuleDefinition)newRule);
        }
        return this.ruleList;
    }

    private void setRuleDefinitionValues(RuleDefinition newRule, Rule dslRule) {
        newRule.setName(Strings.unquote((String)dslRule.getName()));
        newRule.setTitle(Strings.unquote((String)dslRule.getTitle()));
        newRule.setDescription(Strings.unquote((String)dslRule.getDescription()));
        ArrayList<RuleLocations> ruleLocs = new ArrayList<RuleLocations>();
        for (RuleLocation loc : dslRule.getRuleLocation()) {
            ruleLocs.add(RuleLocations.valueOf((String)loc.getName()));
        }
        newRule.setRuleLocs(ruleLocs);
    }

    private void convertCreateTaskRule(CreateTaskRuleDefinition newRule, CreateTaskRule dslRule) {
        newRule.setTaskWorkDef(Strings.unquote((String)dslRule.getTaskWorkDef()));
        newRule.setRelatedState(Strings.unquote((String)dslRule.getRelatedState()));
        ArrayList<RuleEventType> ruleEvents = new ArrayList<RuleEventType>();
        for (OnEventType event : dslRule.getOnEvent()) {
            ruleEvents.add(RuleEventType.valueOf((String)event.getName()));
        }
        newRule.setRuleEvents(ruleEvents);
        this.createUserListFromNames(newRule.getAssignees(), (List<UserDef>)dslRule.getAssignees());
    }

    private void convertDecisionReviewRule(DecisionReviewRuleDefinition newRule, CreateDecisionReviewRule dslRule) {
        newRule.setRelatedToState(Strings.unquote((String)dslRule.getRelatedToState()));
        newRule.setBlockingType(ReviewBlockType.valueOf((String)dslRule.getBlockingType().getName()));
        newRule.getRuleEvents().add(RuleEventType.valueOf((String)dslRule.getStateEvent().getName()));
        newRule.setAutoTransitionToDecision(dslRule.getAutoTransitionToDecision() == BooleanDef.TRUE);
        this.createUserListFromNames(newRule.getAssignees(), (List<UserDef>)dslRule.getAssignees());
    }

    private void convertPeerReviewRule(PeerReviewRuleDefinition newRule, CreatePeerReviewRule dslRule) {
        newRule.setRelatedToState(Strings.unquote((String)dslRule.getRelatedToState()));
        newRule.setBlockingType(ReviewBlockType.valueOf((String)dslRule.getBlockingType().getName()));
        newRule.getRuleEvents().add(RuleEventType.valueOf((String)dslRule.getStateEvent().getName()));
        newRule.setLocation(Strings.unquote((String)dslRule.getLocation()));
        this.createUserListFromNames(newRule.getAssignees(), (List<UserDef>)dslRule.getAssignees());
    }

    private void createUserListFromNames(List<IAtsUser> assignees, List<UserDef> userdefs) {
        IAtsUser atsUser = null;
        if (this.userService != null) {
            for (UserDef name : userdefs) {
                String modName = Strings.unquote((String)name.getName());
                try {
                    atsUser = this.userService.getUserByName(modName);
                }
                catch (OseeCoreException oseeCoreException) {
                    OseeLog.log(ConvertAtsDslToRuleDefinition.class, (Level)Level.WARNING, (String)("Could not find user: " + modName));
                }
                if (atsUser == null) continue;
                assignees.add(atsUser);
            }
        }
    }
}

