/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.dsl.integration.internal;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.config.IWorkDefinitionStringProvider;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.user.IAtsUserService;
import org.eclipse.osee.ats.api.workdef.IAtsCompositeLayoutItem;
import org.eclipse.osee.ats.api.workdef.IAtsLayoutItem;
import org.eclipse.osee.ats.api.workdef.IAtsRuleDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsStateDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsWidgetDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinitionService;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinitionStore;
import org.eclipse.osee.ats.api.workdef.IAttributeResolver;
import org.eclipse.osee.ats.api.workdef.model.RuleDefinitionOption;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.dsl.ModelUtil;
import org.eclipse.osee.ats.dsl.atsDsl.AtsDsl;
import org.eclipse.osee.ats.dsl.atsDsl.WorkDef;
import org.eclipse.osee.ats.dsl.integration.internal.ConvertAtsDslToRuleDefinition;
import org.eclipse.osee.ats.dsl.integration.internal.ConvertAtsDslToWorkDefinition;
import org.eclipse.osee.ats.dsl.integration.internal.ConvertWorkDefinitionToAtsDsl;
import org.eclipse.osee.framework.core.util.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.StringOutputStream;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.logger.Log;

public class AtsWorkDefinitionServiceImpl
implements IAtsWorkDefinitionService {
    private IAtsWorkDefinitionStore workDefStore;
    private IAttributeResolver attrResolver;
    private IAtsUserService userService;
    private Log logger;
    private IWorkDefinitionStringProvider workDefinitionStringProvider;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setAtsWorkDefinitionStore(IAtsWorkDefinitionStore workDefStore) {
        this.workDefStore = workDefStore;
    }

    public void setAttributeResolver(IAttributeResolver attrResolver) {
        this.attrResolver = attrResolver;
    }

    public void setAtsUserService(IAtsUserService userService) {
        this.userService = userService;
    }

    public void start() throws OseeCoreException {
        this.logger.info("AtsWorkDefinitionServiceImpl started", new Object[0]);
    }

    public IAtsWorkDefinition copyWorkDefinition(String newName, IAtsWorkDefinition workDef, XResultData resultData) {
        ConvertWorkDefinitionToAtsDsl converter = new ConvertWorkDefinitionToAtsDsl(resultData);
        AtsDsl atsDsl = converter.convert(newName, workDef);
        ConvertAtsDslToWorkDefinition converter2 = new ConvertAtsDslToWorkDefinition(newName, atsDsl, resultData, this.attrResolver, this.userService);
        IAtsWorkDefinition newWorkDef = converter2.convert().iterator().next();
        return newWorkDef;
    }

    public String getStorageString(IAtsWorkDefinition workDef, XResultData resultData) throws Exception {
        ConvertWorkDefinitionToAtsDsl converter = new ConvertWorkDefinitionToAtsDsl(resultData);
        AtsDsl atsDsl = converter.convert(workDef.getName(), workDef);
        StringOutputStream writer = new StringOutputStream();
        ModelUtil.saveModel((AtsDsl)atsDsl, (String)("ats:/mock" + Lib.getDateTimeString() + ".ats"), (OutputStream)writer);
        return writer.toString();
    }

    public List<IAtsRuleDefinition> getRuleDefinitions() {
        List<IAtsRuleDefinition> ruleDefs = new ArrayList<IAtsRuleDefinition>();
        String ruleDefintionsDslStr = this.workDefStore.loadRuleDefinitionString();
        if (Strings.isValid((String)ruleDefintionsDslStr)) {
            try {
                AtsDsl atsDsl = ModelUtil.loadModel((String)"Rule Definitions.ats", (String)ruleDefintionsDslStr);
                ConvertAtsDslToRuleDefinition convert = new ConvertAtsDslToRuleDefinition(atsDsl, ruleDefs, this.userService);
                ruleDefs = convert.convert();
            }
            catch (Exception ex) {
                OseeLog.log(AtsWorkDefinitionServiceImpl.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        return ruleDefs;
    }

    public IAtsWorkDefinition getWorkDef(String workDefId, XResultData resultData) throws Exception {
        Conditions.checkNotNullOrEmpty((String)workDefId, (String)"workDefId");
        String workDefStr = null;
        if (this.workDefinitionStringProvider != null && this.workDefinitionStringProvider.getWorkDefIdToWorkDef() != null) {
            workDefStr = (String)this.workDefinitionStringProvider.getWorkDefIdToWorkDef().get(workDefId);
        }
        if (workDefStr == null) {
            workDefStr = this.workDefStore.loadWorkDefinitionString(workDefId);
        }
        Conditions.checkNotNullOrEmpty(workDefStr, (String)"workDefStr");
        AtsDsl atsDsl = ModelUtil.loadModel((String)(String.valueOf(workDefId) + ".ats"), (String)workDefStr);
        ConvertAtsDslToWorkDefinition convert = new ConvertAtsDslToWorkDefinition(workDefId, atsDsl, resultData, this.attrResolver, this.userService);
        for (IAtsWorkDefinition workDef : convert.convert()) {
            if (!workDef.getId().equals(workDefId)) continue;
            return workDef;
        }
        return null;
    }

    public boolean isStateWeightingEnabled(IAtsWorkDefinition workDef) {
        for (IAtsStateDefinition stateDef : workDef.getStates()) {
            if (stateDef.getStateWeight() == 0) continue;
            return true;
        }
        return false;
    }

    public Collection<String> getStateNames(IAtsWorkDefinition workDef) {
        ArrayList<String> names = new ArrayList<String>();
        for (IAtsStateDefinition state : workDef.getStates()) {
            names.add(state.getName());
        }
        return names;
    }

    public List<IAtsStateDefinition> getStatesOrderedByOrdinal(IAtsWorkDefinition workDef) {
        ArrayList<IAtsStateDefinition> orderedPages = new ArrayList<IAtsStateDefinition>();
        ArrayList<IAtsStateDefinition> unOrderedPages = new ArrayList<IAtsStateDefinition>();
        int x = 1;
        while (x < workDef.getStates().size() + 1) {
            for (IAtsStateDefinition state : workDef.getStates()) {
                if (state.getOrdinal() == x) {
                    orderedPages.add(state);
                    continue;
                }
                if (state.getOrdinal() != 0 || unOrderedPages.contains(state)) continue;
                unOrderedPages.add(state);
            }
            ++x;
        }
        orderedPages.addAll(unOrderedPages);
        return orderedPages;
    }

    public void getStatesOrderedByDefaultToState(IAtsWorkDefinition workDef, IAtsStateDefinition stateDefinition, List<IAtsStateDefinition> pages) {
        if (pages.contains(stateDefinition)) {
            return;
        }
        pages.add(stateDefinition);
        IAtsStateDefinition defaultToState = stateDefinition.getDefaultToState();
        if (defaultToState != null && !defaultToState.getName().equals(stateDefinition.getName())) {
            this.getStatesOrderedByDefaultToState(workDef, stateDefinition.getDefaultToState(), pages);
        }
        for (IAtsStateDefinition stateDef : stateDefinition.getToStates()) {
            if (pages.contains(stateDef)) continue;
            this.getStatesOrderedByDefaultToState(workDef, stateDef, pages);
        }
    }

    public List<IAtsWidgetDefinition> getWidgetsFromLayoutItems(IAtsStateDefinition stateDef) {
        ArrayList<IAtsWidgetDefinition> widgets = new ArrayList<IAtsWidgetDefinition>();
        AtsWorkDefinitionServiceImpl.getWidgets(stateDef, widgets, stateDef.getLayoutItems());
        return widgets;
    }

    private static void getWidgets(IAtsStateDefinition stateDef, List<IAtsWidgetDefinition> widgets, List<IAtsLayoutItem> stateItems) {
        for (IAtsLayoutItem stateItem : stateItems) {
            if (stateItem instanceof IAtsCompositeLayoutItem) {
                AtsWorkDefinitionServiceImpl.getWidgets(stateDef, widgets, ((IAtsCompositeLayoutItem)stateItem).getaLayoutItems());
                continue;
            }
            if (!(stateItem instanceof IAtsWidgetDefinition)) continue;
            widgets.add((IAtsWidgetDefinition)stateItem);
        }
    }

    public boolean hasWidgetNamed(IAtsStateDefinition stateDef, String name) {
        for (IAtsWidgetDefinition widgetDef : this.getWidgetsFromLayoutItems(stateDef)) {
            if (!widgetDef.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public IAtsWorkDefinition getWorkDefinition(String workDefinitionDsl) throws Exception {
        AtsDsl atsDsl = ModelUtil.loadModel((String)"model.ats", (String)workDefinitionDsl);
        XResultData result = new XResultData(false);
        ConvertAtsDslToWorkDefinition convert = new ConvertAtsDslToWorkDefinition(Strings.unquote((String)((WorkDef)atsDsl.getWorkDef().iterator().next()).getName()), atsDsl, result, this.attrResolver, this.userService);
        if (!result.isEmpty()) {
            throw new IllegalStateException(result.toString());
        }
        return convert.convert().iterator().next();
    }

    public boolean teamDefHasRule(IAtsWorkItem workItem, RuleDefinitionOption option) {
        boolean hasRule = false;
        IAtsTeamWorkflow teamWf = null;
        try {
            if (workItem instanceof IAtsTeamWorkflow) {
                teamWf = (IAtsTeamWorkflow)workItem;
            } else if (this instanceof IAtsAbstractReview) {
                teamWf = ((IAtsAbstractReview)this).getParentTeamWorkflow();
            }
            if (teamWf != null) {
                hasRule = teamWf.getTeamDefinition().hasRule(option.name());
            }
        }
        catch (Exception ex) {
            OseeLog.log(AtsWorkDefinitionServiceImpl.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        return hasRule;
    }

    public boolean isInState(IAtsWorkItem workItem, IAtsStateDefinition stateDef) {
        return workItem.getStateMgr().getCurrentStateName().equals(stateDef.getName());
    }

    public Collection<IAtsWorkDefinition> getAllWorkDefinitions(XResultData resultData) {
        ArrayList<IAtsWorkDefinition> workDefs = new ArrayList<IAtsWorkDefinition>();
        if (this.workDefinitionStringProvider != null && this.workDefinitionStringProvider.getWorkDefIdToWorkDef() != null) {
            for (Map.Entry entry : this.workDefinitionStringProvider.getWorkDefIdToWorkDef().entrySet()) {
                String name = (String)entry.getKey();
                String workDefStr = (String)entry.getValue();
                this.processWorkDef(resultData, workDefs, name, workDefStr);
            }
        } else {
            for (Pair entry : this.workDefStore.getWorkDefinitionStrings()) {
                String name = (String)entry.getFirst();
                String workDefStr = (String)entry.getSecond();
                this.processWorkDef(resultData, workDefs, name, workDefStr);
            }
        }
        return workDefs;
    }

    private void processWorkDef(XResultData resultData, List<IAtsWorkDefinition> workDefs, String name, String workDefStr) {
        try {
            AtsDsl atsDsl = ModelUtil.loadModel((String)(String.valueOf(name) + ".ats"), (String)workDefStr);
            ConvertAtsDslToWorkDefinition convert = new ConvertAtsDslToWorkDefinition(name, atsDsl, resultData, this.attrResolver, this.userService);
            for (IAtsWorkDefinition workDef : convert.convert()) {
                workDefs.add(workDef);
            }
        }
        catch (Exception ex) {
            throw new OseeCoreException((Throwable)ex);
        }
    }

    public Collection<String> getAllValidStateNames(XResultData resultData) {
        HashSet<String> allValidStateNames = new HashSet<String>();
        for (IAtsWorkDefinition workDef : this.getAllWorkDefinitions(resultData)) {
            for (String stateName : this.getStateNames(workDef)) {
                if (allValidStateNames.contains(stateName)) continue;
                allValidStateNames.add(stateName);
            }
        }
        return allValidStateNames;
    }

    public void setWorkDefinitionStringProvider(IWorkDefinitionStringProvider workDefinitionStringProvider) {
        this.workDefinitionStringProvider = workDefinitionStringProvider;
    }
}

