/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.console.admin.internal;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.eclipse.osee.console.admin.Console;
import org.eclipse.osee.console.admin.ConsoleCommand;
import org.eclipse.osee.console.admin.ConsoleParameters;
import org.eclipse.osee.console.admin.internal.AbstractConsoleCallable;
import org.eclipse.osee.console.admin.internal.ConsoleAdminUtils;
import org.eclipse.osee.executor.admin.ExecutionCallback;
import org.eclipse.osee.executor.admin.ExecutorAdmin;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;

public class CommandDispatcher {
    private static final String CONSOLE_EXECUTOR_ID = "org.eclipse.osee.console.executor";
    private final Map<String, ConsoleCommand> registered = new ConcurrentHashMap<String, ConsoleCommand>();
    private final Map<String, Map<String, Future<?>>> futures = new ConcurrentHashMap();
    private final Map<String, String> commandNameToId = new ConcurrentHashMap<String, String>();
    private final Log logger;
    private final ExecutorAdmin executorAdmin;

    public CommandDispatcher(Log logger, ExecutorAdmin executorAdmin) {
        this.logger = logger;
        this.executorAdmin = executorAdmin;
    }

    public Collection<ConsoleCommand> getRegistered() {
        return this.registered.values();
    }

    public void register(String id, ConsoleCommand command) {
        this.registered.put(id, command);
        this.commandNameToId.put(command.getName().toLowerCase(), id);
    }

    public void unregister(String id) {
        this.cancelAllTasksFor(id);
        ConsoleCommand command = this.registered.remove(id);
        if (command != null) {
            this.commandNameToId.remove(command.getName().toLowerCase());
        }
    }

    public Future<?> dispatch(Console console, ConsoleParameters params) throws Exception {
        String cmdId = this.getCommandId(params);
        ConsoleCommand command = this.getCommandById(cmdId);
        ConsoleAdminUtils.checkNotNull(command, "command", "Unable to find command for [%s]", cmdId);
        Callable<?> callable = this.createCallable(command, console, params);
        return this.execute(cmdId, callable);
    }

    private Callable<?> createCallable(final ConsoleCommand command, final Console console, final ConsoleParameters params) {
        AbstractConsoleCallable<Object> wrapped = new AbstractConsoleCallable<Object>(console, params){

            @Override
            protected Object innerCall() throws Exception {
                Callable<?> callable = command.createCallable(console, params);
                return this.callAndCheckForCancel(callable);
            }
        };
        return wrapped;
    }

    private <T> Future<T> execute(final String cmdId, Callable<T> callable) throws Exception {
        final String guid = GUID.create();
        Future future = this.getExecutorAdmin().schedule(CONSOLE_EXECUTOR_ID, callable, new ExecutionCallback<T>(){

            public void onCancelled() {
                this.removeFuture();
            }

            public void onSuccess(T result) {
                this.removeFuture();
            }

            public void onFailure(Throwable throwable) {
                this.removeFuture();
            }

            private void removeFuture() {
                Map items = (Map)CommandDispatcher.this.futures.get(cmdId);
                items.remove(guid);
                if (items.isEmpty()) {
                    CommandDispatcher.this.futures.remove(cmdId);
                }
            }
        });
        Map<String, Future<?>> items = this.futures.get(cmdId);
        if (items == null) {
            items = new ConcurrentHashMap();
            this.futures.put(cmdId, items);
        }
        items.put(guid, future);
        return future;
    }

    public void cancelAllTasksFor(String cmdId) {
        if (Strings.isValid((String)cmdId)) {
            Map<String, Future<?>> items = this.futures.get(cmdId);
            if (items != null) {
                for (Future<?> item : items.values()) {
                    item.cancel(true);
                }
                if (items.isEmpty()) {
                    this.futures.remove(cmdId);
                }
            }
        } else {
            this.getLogger().warn("Null command id received", new Object[0]);
        }
    }

    private ConsoleCommand getCommandById(String commandId) throws Exception {
        ConsoleAdminUtils.checkNotNull(commandId, "commandId");
        return this.registered.get(commandId);
    }

    public ConsoleCommand getCommandByName(String commandName) throws Exception {
        String commandId = this.getCommandIdByName(commandName);
        return this.getCommandById(commandId);
    }

    private String getCommandIdByName(String commandName) {
        ConsoleAdminUtils.checkNotNullOrEmpty(commandName, "command name");
        return this.commandNameToId.get(commandName);
    }

    private String getCommandId(ConsoleParameters params) throws Exception {
        String commandName = params.getCommandName();
        return this.getCommandIdByName(commandName);
    }

    private ExecutorAdmin getExecutorAdmin() {
        return this.executorAdmin;
    }

    private Log getLogger() {
        return this.logger;
    }
}

