/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.console.admin.internal;

import java.util.concurrent.Callable;
import org.eclipse.osee.console.admin.Console;
import org.eclipse.osee.console.admin.ConsoleParameters;
import org.eclipse.osee.executor.admin.CancellableCallable;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public abstract class AbstractConsoleCallable<T>
extends CancellableCallable<T> {
    private final Console console;
    private final ConsoleParameters params;
    private Callable<?> innerWorker;

    public AbstractConsoleCallable(Console console, ConsoleParameters params) {
        this.console = console;
        this.params = params;
    }

    public final T call() throws Exception {
        T result;
        long startTime = System.currentTimeMillis();
        try {
            result = this.innerCall();
        }
        catch (Throwable throwable) {
            this.console.writeln("Console Command - [%s] completed in [%s]", this.params.getRawString(), Lib.getElapseString((long)startTime));
            throw throwable;
        }
        this.console.writeln("Console Command - [%s] completed in [%s]", this.params.getRawString(), Lib.getElapseString((long)startTime));
        return result;
    }

    protected abstract T innerCall() throws Exception;

    protected <K> K callAndCheckForCancel(Callable<K> callable) throws Exception {
        this.checkForCancelled();
        this.setInnerWorker(callable);
        K result = callable.call();
        this.setInnerWorker(null);
        return result;
    }

    private synchronized void setInnerWorker(Callable<?> callable) {
        this.innerWorker = callable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCancel(boolean isCancelled) {
        super.setCancel(isCancelled);
        Callable<?> inner = this.innerWorker;
        if (inner != null) {
            Callable<?> callable = inner;
            synchronized (callable) {
                if (inner instanceof CancellableCallable) {
                    ((CancellableCallable)inner).setCancel(isCancelled);
                }
            }
        }
    }
}

