/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.parser.antlr;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public class AntlrGrammarComparator {
    private static final List<String> SINGLE_CHAR_TOKENS = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"\\(", "\\)", "\\[", "\\]", "\\{", "\\}", "\\|", "=", "\\?", "\\*", "\\+", ":", ";"}));
    private static final String QUOTED_TOKENS = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"'(\\\\')+'", "('[^']*')", "(\"[^\"]*\")"})), (CharSequence)"|");
    private static final String TOKEN = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            String _join = IterableExtensions.join((Iterable)SINGLE_CHAR_TOKENS, (CharSequence)"|");
            _builder.append((Object)_join, "");
            _builder.append((Object)"|");
            _builder.append((Object)QUOTED_TOKENS, "");
            _builder.append((Object)"|[^\\s'\"");
            String _join_1 = IterableExtensions.join((Iterable)SINGLE_CHAR_TOKENS);
            _builder.append((Object)_join_1, "");
            _builder.append((Object)"]+");
            return _builder.toString();
        }
    }.apply();
    private static final String NEWLINE = "\\r?\\n|\\r";
    private static final String WS = "( |\\t)+";
    private static final String SL_COMMENT = "//[^\\r\\n]*";
    private static final String ML_COMMENT = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"/\\*(\\*[^/]|[^\\*])*\\*/");
            return _builder.toString();
        }
    }.apply();
    private final Pattern p_slComment = Pattern.compile("//[^\\r\\n]*");
    private final Pattern p_mlComment = Pattern.compile(ML_COMMENT);
    private final Pattern p_token = Pattern.compile(TOKEN);
    private final Pattern p_newline = Pattern.compile("\\r?\\n|\\r");
    private final Pattern p_ws = Pattern.compile("( |\\t)+");
    private final Pattern compoundPattern = new Functions.Function0<Pattern>(){

        public Pattern apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"(");
            _builder.append((Object)AntlrGrammarComparator.SL_COMMENT, "");
            _builder.append((Object)")|(");
            _builder.append((Object)ML_COMMENT, "");
            _builder.append((Object)")|(");
            _builder.append((Object)TOKEN, "");
            _builder.append((Object)")|(");
            _builder.append((Object)AntlrGrammarComparator.NEWLINE, "");
            _builder.append((Object)")|(");
            _builder.append((Object)AntlrGrammarComparator.WS, "");
            _builder.append((Object)")");
            Pattern _compile = Pattern.compile(_builder.toString(), 8);
            return _compile;
        }
    }.apply();
    private ErrorContext errorContext;

    public ErrorContext compareGrammars(CharSequence grammar, CharSequence grammarReference, String absoluteGrammarFileName, String absoluteGrammarFileNameReference, IErrorHandler errorHandler) {
        ErrorContext _errorContext;
        this.errorContext = _errorContext = new ErrorContext();
        this.errorContext.testedGrammar.absoluteFileName = absoluteGrammarFileName;
        this.errorContext.referenceGrammar.absoluteFileName = absoluteGrammarFileNameReference;
        return this.compareGrammars(grammar, grammarReference, errorHandler);
    }

    public ErrorContext compareGrammars(CharSequence grammar, CharSequence grammarReference, IErrorHandler errorHandler) {
        boolean _equals = Objects.equal((Object)this.errorContext, null);
        if (_equals) {
            ErrorContext _errorContext;
            this.errorContext = _errorContext = new ErrorContext();
        }
        Matcher compoundMatcher = this.compoundPattern.matcher(grammar);
        Matcher compoundMatcherReference = this.compoundPattern.matcher(grammarReference);
        boolean continue_ = true;
        boolean continueReference = true;
        while (continue_ || continueReference) {
            boolean _notEquals;
            if (continue_) {
                boolean _nextToken;
                continue_ = _nextToken = this.nextToken(compoundMatcher, this.errorContext.testedGrammar, errorHandler);
            }
            String _xifexpression = null;
            _xifexpression = continue_ ? compoundMatcher.group() : "\u00ab\u00abeof\u00bb\u00bb";
            String match = _xifexpression;
            if (continueReference) {
                boolean _nextToken_1;
                continueReference = _nextToken_1 = this.nextToken(compoundMatcherReference, this.errorContext.referenceGrammar, errorHandler);
            }
            String _xifexpression_1 = null;
            _xifexpression_1 = continueReference ? compoundMatcherReference.group() : "\u00ab\u00abeof\u00bb\u00bb";
            String matchReference = _xifexpression_1;
            boolean bl = _notEquals = !Objects.equal((Object)matchReference, (Object)match);
            if (!_notEquals) continue;
            errorHandler.handleMismatch(match, matchReference, this.errorContext);
        }
        return this.errorContext;
    }

    private boolean nextToken(Matcher matcher, MatchState state, IErrorHandler errorHandler) {
        while (matcher.find()) {
            boolean _notEquals;
            String _group = matcher.group();
            state.currentToken = _group;
            int _start = matcher.start();
            boolean bl = _notEquals = _start != state.position;
            if (_notEquals) {
                this.handleInvalidGrammarFile(errorHandler, state);
            }
            String match = matcher.group();
            state.previousToken = match;
            int _end = matcher.end();
            state.position = _end;
            Matcher _matcher = this.p_newline.matcher(match);
            boolean _matches = _matcher.matches();
            if (_matches) {
                MatchState matchState = state;
                matchState.lineNumber = matchState.lineNumber + 1;
                continue;
            }
            if (this.p_slComment.matcher(match).matches() || this.p_ws.matcher(match).matches()) continue;
            Matcher _matcher_1 = this.p_mlComment.matcher(match);
            boolean _matches_1 = _matcher_1.matches();
            if (_matches_1) {
                Matcher newlines = this.p_newline.matcher(match);
                while (newlines.find()) {
                    MatchState matchState = state;
                    matchState.lineNumber = matchState.lineNumber + 1;
                }
                continue;
            }
            Matcher _matcher_2 = this.p_token.matcher(match);
            boolean _matches_2 = _matcher_2.matches();
            if (!_matches_2) continue;
            return true;
        }
        return false;
    }

    private void handleInvalidGrammarFile(IErrorHandler errorHandler, MatchState state) {
        if (state == this.errorContext.testedGrammar) {
            errorHandler.handleInvalidGeneratedGrammarFile(this.errorContext);
        } else {
            errorHandler.handleInvalidReferenceGrammarFile(this.errorContext);
        }
    }

    public static final class ErrorContext {
        @Accessors
        private MatchState testedGrammar = new MatchState();
        @Accessors
        private MatchState referenceGrammar = new MatchState();

        public MatchState reset() {
            MatchState _matchState_1;
            MatchState _matchState;
            MatchState _xblockexpression = null;
            this.testedGrammar = _matchState = new MatchState();
            _xblockexpression = this.referenceGrammar = (_matchState_1 = new MatchState());
            return _xblockexpression;
        }

        @Pure
        public MatchState getTestedGrammar() {
            return this.testedGrammar;
        }

        public void setTestedGrammar(MatchState testedGrammar) {
            this.testedGrammar = testedGrammar;
        }

        @Pure
        public MatchState getReferenceGrammar() {
            return this.referenceGrammar;
        }

        public void setReferenceGrammar(MatchState referenceGrammar) {
            this.referenceGrammar = referenceGrammar;
        }
    }

    public static interface IErrorHandler {
        public void handleInvalidGeneratedGrammarFile(ErrorContext var1);

        public void handleInvalidReferenceGrammarFile(ErrorContext var1);

        public void handleMismatch(String var1, String var2, ErrorContext var3);
    }

    public static final class MatchState {
        @Accessors
        private String absoluteFileName;
        @Accessors
        private int lineNumber = 1;
        private int position = 0;
        @Accessors
        private String previousToken;
        @Accessors
        private String currentToken;

        @Pure
        public String getAbsoluteFileName() {
            return this.absoluteFileName;
        }

        public void setAbsoluteFileName(String absoluteFileName) {
            this.absoluteFileName = absoluteFileName;
        }

        @Pure
        public int getLineNumber() {
            return this.lineNumber;
        }

        public void setLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
        }

        @Pure
        public String getPreviousToken() {
            return this.previousToken;
        }

        public void setPreviousToken(String previousToken) {
            this.previousToken = previousToken;
        }

        @Pure
        public String getCurrentToken() {
            return this.currentToken;
        }

        public void setCurrentToken(String currentToken) {
            this.currentToken = currentToken;
        }
    }
}

