/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.dsl.integration.internal;

import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.data.IRelationType;
import org.eclipse.osee.framework.core.data.TokenFactory;
import org.eclipse.osee.framework.core.dsl.oseeDsl.AccessPermissionEnum;
import org.eclipse.osee.framework.core.dsl.oseeDsl.ObjectRestriction;
import org.eclipse.osee.framework.core.dsl.oseeDsl.OseeType;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XArtifactType;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XAttributeType;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XRelationSideEnum;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XRelationType;
import org.eclipse.osee.framework.core.enums.PermissionEnum;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public final class OseeUtil {
    private OseeUtil() {
    }

    private static long checkAndGetUuid(OseeType type) throws OseeCoreException {
        String uuid = type.getId();
        Conditions.checkNotNull((Object)uuid, (String)"uuid", (String)"for type [%s]", (Object[])new Object[]{type.getName()});
        return Long.valueOf(uuid);
    }

    public static IArtifactType toToken(XArtifactType model) throws OseeCoreException {
        return TokenFactory.createArtifactType((long)OseeUtil.checkAndGetUuid((OseeType)model), (String)Strings.unquote((String)model.getName()));
    }

    public static AttributeTypeId toToken(XAttributeType model) throws OseeCoreException {
        return AttributeTypeToken.valueOf((long)OseeUtil.checkAndGetUuid((OseeType)model), (String)Strings.unquote((String)model.getName()));
    }

    public static IRelationType toToken(XRelationType model) throws OseeCoreException {
        return TokenFactory.createRelationType((long)OseeUtil.checkAndGetUuid((OseeType)model), (String)Strings.unquote((String)model.getName()));
    }

    public static boolean isRestrictedSide(XRelationSideEnum relationSideEnum, RelationSide relationSide) throws OseeCoreException {
        Conditions.checkNotNull((Object)relationSideEnum, (String)"relation side restriction");
        Conditions.checkNotNull((Object)relationSide, (String)"relation side");
        boolean toReturn = false;
        switch (relationSideEnum) {
            case BOTH: {
                toReturn = true;
                break;
            }
            case SIDE_A: {
                toReturn = relationSide.isSideA();
                break;
            }
            case SIDE_B: {
                toReturn = !relationSide.isSideA();
                break;
            }
        }
        return toReturn;
    }

    public static PermissionEnum getPermission(ObjectRestriction restriction) throws OseeCoreException {
        Conditions.checkNotNull((Object)restriction, (String)"restriction");
        AccessPermissionEnum modelPermission = restriction.getPermission();
        Conditions.checkNotNull((Object)modelPermission, (String)"restriction permission");
        PermissionEnum toReturn = modelPermission == AccessPermissionEnum.ALLOW ? PermissionEnum.WRITE : PermissionEnum.READ;
        return toReturn;
    }
}

