/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.dsl.integration.internal;

import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.dsl.integration.ArtifactDataProvider;
import org.eclipse.osee.framework.core.dsl.integration.RestrictionHandler;
import org.eclipse.osee.framework.core.dsl.integration.internal.OseeUtil;
import org.eclipse.osee.framework.core.dsl.oseeDsl.AttributeTypeRestriction;
import org.eclipse.osee.framework.core.dsl.oseeDsl.ObjectRestriction;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XArtifactType;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XAttributeType;
import org.eclipse.osee.framework.core.enums.PermissionEnum;
import org.eclipse.osee.framework.core.model.access.AccessDetail;
import org.eclipse.osee.framework.core.model.access.AccessDetailCollector;
import org.eclipse.osee.framework.core.model.access.Scope;
import org.eclipse.osee.framework.core.model.type.ArtifactType;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;

public class AttributeTypeRestrictionHandler
implements RestrictionHandler<AttributeTypeRestriction> {
    @Override
    public AttributeTypeRestriction asCastedObject(ObjectRestriction objectRestriction) {
        AttributeTypeRestriction toReturn = null;
        if (objectRestriction instanceof AttributeTypeRestriction) {
            toReturn = (AttributeTypeRestriction)objectRestriction;
        }
        return toReturn;
    }

    @Override
    public void process(ObjectRestriction objectRestriction, ArtifactDataProvider.ArtifactProxy artifactProxy, AccessDetailCollector collector, Scope scopeLevel) throws OseeCoreException {
        AttributeTypeRestriction restriction = this.asCastedObject(objectRestriction);
        if (restriction != null) {
            XArtifactType artifactTypeRef;
            XAttributeType attributeTypeRef = restriction.getAttributeTypeRef();
            AttributeTypeId attributeTypeToMatch = OseeUtil.toToken(attributeTypeRef);
            boolean isApplicable = artifactProxy.isAttributeTypeValid(attributeTypeToMatch);
            if (isApplicable && (artifactTypeRef = restriction.getArtifactTypeRef()) != null) {
                isApplicable = false;
                IArtifactType typeToMatch = OseeUtil.toToken(artifactTypeRef);
                ArtifactType artifactType = artifactProxy.getArtifactType();
                isApplicable = artifactType.inheritsFrom(new ArtifactTypeId[]{typeToMatch});
            }
            if (isApplicable) {
                PermissionEnum permission = OseeUtil.getPermission((ObjectRestriction)restriction);
                collector.collect(new AccessDetail((Object)attributeTypeToMatch, permission, scopeLevel));
            }
        }
    }
}

