/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.dsl.integration.internal;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.dsl.integration.ArtifactDataProvider;
import org.eclipse.osee.framework.core.dsl.oseeDsl.CompareOp;
import org.eclipse.osee.framework.core.dsl.oseeDsl.CompoundCondition;
import org.eclipse.osee.framework.core.dsl.oseeDsl.Condition;
import org.eclipse.osee.framework.core.dsl.oseeDsl.MatchField;
import org.eclipse.osee.framework.core.dsl.oseeDsl.SimpleCondition;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XArtifactMatcher;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XLogicOperator;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class ArtifactMatchInterpreter {
    private final Map<String, Matcher> expressions = new ConcurrentHashMap<String, Matcher>();

    public boolean matches(XArtifactMatcher matcher, Collection<ArtifactDataProvider.ArtifactProxy> proxies) throws OseeCoreException {
        boolean matched = false;
        Iterator<ArtifactDataProvider.ArtifactProxy> iterator = proxies.iterator();
        while (iterator.hasNext() && !matched) {
            matched = this.matches(matcher, iterator.next());
            if (matched) break;
        }
        return matched;
    }

    public boolean matches(XArtifactMatcher matcher, ArtifactDataProvider.ArtifactProxy proxy) throws OseeCoreException {
        EList conditions = matcher.getConditions();
        EList operators = matcher.getOperators();
        return this.evaluate((List<? extends Condition>)conditions, (List<? extends XLogicOperator>)operators, proxy);
    }

    boolean evaluate(List<? extends Condition> conditions, List<? extends XLogicOperator> operators, ArtifactDataProvider.ArtifactProxy proxy) throws OseeCoreException {
        boolean result = false;
        Iterator<? extends Condition> iteratorConds = conditions.iterator();
        Iterator<? extends XLogicOperator> iteratorOps = operators.iterator();
        if (iteratorConds.hasNext()) {
            Condition lastCondition = iteratorConds.next();
            if (iteratorOps.hasNext()) {
                while (iteratorOps.hasNext() && iteratorConds.hasNext()) {
                    XLogicOperator op = iteratorOps.next();
                    Condition condition = iteratorConds.next();
                    result = this.evaluate(op, lastCondition, condition, proxy);
                }
            } else {
                result = this.evaluate(lastCondition, proxy);
            }
        }
        return result;
    }

    boolean evaluate(XLogicOperator op, Condition conditionA, Condition conditionB, ArtifactDataProvider.ArtifactProxy proxy) throws OseeCoreException {
        boolean result = this.evaluate(conditionA, proxy);
        if (op == XLogicOperator.AND) {
            return result && this.evaluate(conditionB, proxy);
        }
        if (op == XLogicOperator.OR) {
            return result || this.evaluate(conditionB, proxy);
        }
        throw new OseeArgumentException("Invalid op defined: %s", new Object[]{op});
    }

    boolean evaluate(Condition condition, ArtifactDataProvider.ArtifactProxy proxy) throws OseeCoreException {
        if (condition instanceof SimpleCondition) {
            return this.evaluate((SimpleCondition)condition, proxy);
        }
        if (condition instanceof CompoundCondition) {
            CompoundCondition group = (CompoundCondition)condition;
            return this.evaluate((List<? extends Condition>)group.getConditions(), (List<? extends XLogicOperator>)group.getOperators(), proxy);
        }
        throw new OseeArgumentException("Invalid Condition defined: %s", new Object[]{condition});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean evaluate(SimpleCondition condition, ArtifactDataProvider.ArtifactProxy proxy) throws OseeCoreException {
        String expression = Strings.unquote((String)condition.getExpression());
        Conditions.checkNotNullOrEmpty((String)expression, (String)"expression");
        String input = null;
        MatchField field = condition.getField();
        switch (field) {
            case ARTIFACT_ID: {
                input = (String)proxy.getGuid();
                Conditions.checkExpressionFailOnTrue((!GUID.isValid((String)input) ? 1 : 0) != 0, (String)"guid", (Object[])new Object[0]);
                break;
            }
            case BRANCH_UUID: {
                BranchId branch = proxy.getBranch();
                Conditions.checkExpressionFailOnTrue((boolean)branch.isInvalid(), (String)String.format("branch id should be > 0, but is [%s]", branch.getIdString()), (Object[])new Object[0]);
                input = branch.getIdString();
                break;
            }
            case ARTIFACT_NAME: {
                input = proxy.getName();
                break;
            }
            case BRANCH_NAME: {
                input = proxy.getBranchToken().getName();
                break;
            }
            default: {
                throw new OseeArgumentException("Invalid field [%s]", new Object[]{field});
            }
        }
        Conditions.checkNotNullOrEmpty((String)input, (String)field.getName());
        CompareOp op = condition.getOp();
        boolean result = false;
        if (op == CompareOp.EQ) {
            result = input.equals(expression);
        } else if (op == CompareOp.LIKE) {
            Matcher matcher = this.expressions.get(expression);
            if (matcher == null) {
                Pattern pattern = Pattern.compile(expression);
                matcher = pattern.matcher("");
                this.expressions.put(expression, matcher);
            }
            Matcher matcher2 = matcher;
            synchronized (matcher2) {
                matcher.reset(input);
                result = matcher.find();
            }
        } else {
            throw new OseeArgumentException("Invalid CompareOp [%s]", new Object[]{op});
        }
        return result;
    }
}

