/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.dsl.integration.internal;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.IAccessContextId;
import org.eclipse.osee.framework.core.dsl.integration.AccessModelInterpreter;
import org.eclipse.osee.framework.core.dsl.integration.ArtifactDataProvider;
import org.eclipse.osee.framework.core.dsl.integration.RestrictionHandler;
import org.eclipse.osee.framework.core.dsl.integration.internal.AccessModelInterpreterImpl;
import org.eclipse.osee.framework.core.dsl.integration.internal.ArtifactMatchInterpreter;
import org.eclipse.osee.framework.core.dsl.integration.internal.ArtifactMatchRestrictionHandler;
import org.eclipse.osee.framework.core.dsl.integration.internal.ArtifactTypeRestrictionHandler;
import org.eclipse.osee.framework.core.dsl.integration.internal.AttributeTypeRestrictionHandler;
import org.eclipse.osee.framework.core.dsl.integration.internal.RelationTypeRestrictionHandler;
import org.eclipse.osee.framework.core.dsl.oseeDsl.AccessContext;
import org.eclipse.osee.framework.core.model.access.AccessDetailCollector;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public class AccessModelInterpreterProxy
implements AccessModelInterpreter {
    private ArtifactDataProvider artifactDataProvider;
    private AccessModelInterpreter proxiedService;

    public void setArtifactDataProvider(ArtifactDataProvider artifactDataProvider) {
        this.artifactDataProvider = artifactDataProvider;
    }

    public void start() {
    }

    public void stop() {
        this.proxiedService = null;
    }

    private boolean isReady() {
        return this.artifactDataProvider != null;
    }

    private synchronized AccessModelInterpreter getProxiedService() {
        if (this.isReady() && this.proxiedService == null) {
            ArtifactMatchInterpreter matcher = new ArtifactMatchInterpreter();
            RestrictionHandler[] restrictionHandlers = new RestrictionHandler[]{new ArtifactMatchRestrictionHandler(matcher), new ArtifactTypeRestrictionHandler(), new AttributeTypeRestrictionHandler(), new RelationTypeRestrictionHandler(matcher)};
            this.proxiedService = new AccessModelInterpreterImpl(this.artifactDataProvider, matcher, restrictionHandlers);
        }
        return this.proxiedService;
    }

    private void checkInitialized() throws OseeCoreException {
        Conditions.checkNotNull((Object)this.getProxiedService(), (String)"AccessModelInterpreter");
    }

    @Override
    public AccessContext getContext(Collection<AccessContext> contexts, IAccessContextId contextId) throws OseeCoreException {
        this.checkInitialized();
        return this.getProxiedService().getContext(contexts, contextId);
    }

    @Override
    public void computeAccessDetails(AccessDetailCollector collector, AccessContext context, Object objectToCheck) throws OseeCoreException {
        this.checkInitialized();
        this.getProxiedService().computeAccessDetails(collector, context, objectToCheck);
    }
}

